package com.scan.service;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import com.scan.service.config.ScanConfig;

public class MainActivity extends Activity {
	private ScanConfig scanConfig;

	private Switch openSwitch;
	private Spinner spinnerPrefix;
	private Spinner spinnerSurfix;
	private CheckBox checkVoice;
	private TextView tvPrefix ;
	private TextView tvSurfix ;
	
//	private String tabStr;
	private   String spaceStr;
//	private   String enterStr;
	private   String noneStr;
	private   String otherStr;
	private String[] fixArray;
	
	private Dialog dialogLoading ;
	private Dialog dialogOther ;
	
	private RadioButton radio1D ;
	private RadioButton radio2D ;
	private CheckBox checkTab ;
	private CheckBox checkEnter ;
	
	private boolean is1D = false;
	
	private final int MSG_CANSEL_DIALOG = 1003 ;
	private Handler mHandler  = new Handler(){
		public void handleMessage(Message msg) {
			switch (msg.what) {
			case MSG_CANSEL_DIALOG:
				dialogLoading.cancel() ;
				scanConfig.setOpen(true) ;
				break;

			default:
				break;
			}
		};
	};
	
	
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		scanConfig = new ScanConfig(this);
		initView();
	}
	
	
	
	
	//initView
	private void initView() {
//		tabStr = getResources().getString(R.string.tab);
		spaceStr = getResources().getString(R.string.space);
//		enterStr = getResources().getString(R.string.enter);
		noneStr = getResources().getString(R.string.none);
		otherStr = getResources().getString(R.string.other);
		fixArray = new String[] {  spaceStr,  noneStr, otherStr };
		tvPrefix = (TextView) findViewById(R.id.text_prefix) ;
		tvSurfix = (TextView) findViewById(R.id.text_surfix) ;
		checkTab = (CheckBox) findViewById(R.id.checkBox_surfix_tab) ;
		checkEnter = (CheckBox) findViewById(R.id.checkBox_surfix_enter) ;

		radio1D = (RadioButton) findViewById(R.id.radioButton_1d) ;
		radio2D = (RadioButton) findViewById(R.id.radioButton_2d) ;
		radio1D.setChecked(scanConfig.is1D()) ;
		radio2D.setChecked(!scanConfig.is1D()) ;
		openSwitch = (Switch) findViewById(R.id.switch_scan);
		spinnerPrefix = (Spinner) findViewById(R.id.spinner_prefix);
		spinnerSurfix = (Spinner) findViewById(R.id.spinner_surfix);
		checkVoice = (CheckBox) findViewById(R.id.checkBox_voice);
		
		if(scanConfig.isOpen()){
			setRadio(radio1D, false) ;
			setRadio(radio2D, false) ;
		}

		openSwitch.setChecked(scanConfig.isOpen()) ;
		checkVoice.setChecked(scanConfig.isVoice());

		spinnerPrefix.setAdapter(new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_dropdown_item, fixArray));
		spinnerPrefix.setSelection(1);
		spinnerSurfix.setAdapter(new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_dropdown_item, fixArray));
		spinnerSurfix.setSelection(1);
		checkEnter.setChecked(scanConfig.isEnter()) ;
		checkTab.setChecked(scanConfig.isTab()) ;

		checkVoice.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				scanConfig.setVoice(isChecked);
			}
		});
		checkEnter.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setEnter(isChecked) ;
				
			}
		}) ;
		checkTab.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				scanConfig.setTab(isChecked) ;
				
			}
		}) ;

		// open dev
		openSwitch.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				// open scan
				if (isChecked) {
					createLoaddingDialog() ;
					Intent intent = new Intent(MainActivity.this, FloatWindow.class);
					startService(intent);
					Timer timer = new Timer() ;
					timer.schedule(new TimerTask() {
						
						@Override
						public void run() {
							Message msg = new Message() ;
							msg.what = MSG_CANSEL_DIALOG ;
							mHandler.sendMessage(msg) ;
							
						}
					}, 3500) ;
					
					setRadio(radio1D, false) ;
					setRadio(radio2D, false) ;
					
				} else {
					Intent stopIntent = new Intent();
					stopIntent.setAction("com.example.scanservice.FloatWindow");
					sendBroadcast(stopIntent);
					
					Intent toKill = new Intent() ;
					toKill.setAction(ScanService.ACTION_CLOSE_SCAN) ;
					toKill.putExtra("kill", true) ;
					sendBroadcast(toKill) ;
					scanConfig.setOpen(false) ;
					
					setRadio(radio1D, true) ;
					setRadio(radio2D, true) ;
				}

			}
		});

		// prefix
		spinnerPrefix.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				
				 if(fixArray[position].equals(spaceStr)){
					scanConfig.setPrefix(" ");
				}else if(fixArray[position].equals(noneStr)){
					scanConfig.setPrefix("");
				}else if(fixArray[position].equals(otherStr)){
					//dialog input prefix char
					createOtherDialog(true) ;
				}

			}

			@Override
			public void onNothingSelected(AdapterView<?> parent) {
				Log.e("nothing selected", "") ;

			}
		});

		// surfix
		spinnerSurfix.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view,
					int position, long id) {
				if(fixArray[position].equals(spaceStr)){
					scanConfig.setSurfix(" ");
				}if(fixArray[position].equals(noneStr)){
					scanConfig.setSurfix("");
				}else if(fixArray[position].equals(otherStr)){
					//dialog input surfix char
					createOtherDialog(false) ;
				}

			}

			@Override
			public void onNothingSelected(AdapterView<?> parent) {
				// TODO Auto-generated method stub

			}
		});
		
		radio1D.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				if(isChecked){
					scanConfig.set1D(true) ;
				}
				
				
			}
		}) ;
		
		radio2D.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				
				if(isChecked){
					scanConfig.set1D(false) ;
				}
				
			}
		}) ;
		

	}
	
	
	//set radio 
	private void setRadio(RadioButton radio, boolean flag){
		radio.setClickable(flag) ;
		if(flag){
			radio.setTextColor(Color.BLACK) ;
		}else{
			radio.setTextColor(Color.GRAY) ;
		}
	}
	
	
	
	
	
	
	//create loading dialog
	private void createLoaddingDialog(){
		Builder  builder = new Builder(this) ;
		View view = LayoutInflater.from(this).inflate(R.layout.dialog_loading, null) ;
		builder.setView(view) ;
		dialogLoading = builder.create() ;
		dialogLoading.setCancelable(false) ;
		dialogLoading.show() ;
	}
	
	
	private EditText editUserChar ;
	private void createOtherDialog(final boolean isPrefix){
		//Input the customized Char
		Builder  builder = new Builder(this) ;
		View view = LayoutInflater.from(this).inflate(R.layout.dialog_others, null) ;
		editUserChar = (EditText) view.findViewById(R.id.editText_others) ;
		builder.setView(view) ;
		builder.setTitle(getResources().getString(R.string.user_char)) ;
		builder.setNegativeButton(getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialogOther.cancel() ;
			}
		}) ;
		builder.setPositiveButton(getResources().getString(R.string.ok), new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				String userChar = editUserChar.getText().toString() ;
				if(isPrefix){
					tvPrefix.setText(userChar) ;
					scanConfig.setPrefix(userChar) ;
				}else{
					tvSurfix.setText(userChar) ;;
					scanConfig.setSurfix(userChar) ;
				}
				
				dialogOther.cancel() ;
			}
		}) ;
		
		dialogOther = builder.create() ;
//		dialogOther.setCancelable(false) ;
		dialogOther.show() ;
	}
	
}
