package com.scan.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.WindowManager;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;

import com.scan.service.config.ScanConfig;
import com.scan.service.util.Util;

public class FloatWindow extends Service {
	
	private WindowManager wm  ;
	
	private float mTouchX;
	private float mTouchY;
	private float x;
	private float y; 
	private float mStartX;
	private float mStartY; 
	
    LinearLayout mFloatLayout;  
    WindowManager.LayoutParams wmParams;  
    Button btnScan ;
    
    private ScanConfig scanConfig ;
    
    
//	private UhfReader reader  ;
	private String serialportPath = "/dev/ttyMT1";
	private int port = 12 ;
	
	private Set<String> epcSet  = null ; 
    
//	private SwicthMethod swM ;
//    private ScanThread scanThread ;
	private Handler handler = new Handler(){
		public void handleMessage(android.os.Message msg) {
			switch (msg.what) {
			case MSG_UHF:
				String epc = msg.getData().getString(KEY_UHF) ;
				Log.e("msg_epc", epc) ;
//				Intent intent = new Intent(FloatWindow.this, Mservice.class) ;
//				intent.putExtra("epc", epc) ;
//				startService(intent) ;
				break;

			default:
				break;
			}
		};
	};
    

	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void onCreate() {
		Util.initSoundPool(this);
		//鍒涘缓鎮诞绐楀彛
		createFloatWindow();
		//娉ㄥ唽骞挎挱鎺ュ彈鑰�
		initReceiver();
		scanConfig = new ScanConfig(this) ;
		runFlag = true ;
		startFlag = false ;
		Log.e("FloatWindow", "is1D = " + scanConfig.is1D()) ;
		if(scanConfig.is1D()){
			Intent to1D = new Intent(FloatWindow.this, Scan1DService.class) ;
			startService(to1D) ;
		}else{
			Intent intent = new Intent(FloatWindow.this, ScanService.class) ;
			startService(intent) ;
		}

		super.onCreate();
	}
	
	@Override
	public void onDestroy() {
		wm.removeView(mFloatLayout);
		runFlag = false ;
		startFlag = false ;
		if(receiver != null){
			unregisterReceiver(receiver);
		}
		super.onDestroy();
	}
	
	private void createFloatWindow(){
		wmParams = new WindowManager.LayoutParams();
		wm = (WindowManager) getApplication().getSystemService(Context.WINDOW_SERVICE);
		Display display = wm.getDefaultDisplay();
		DisplayMetrics dm = new DisplayMetrics();
		display.getMetrics(dm);
		
		
        wmParams.type = LayoutParams.TYPE_PHONE; 
        wmParams.format = PixelFormat.RGBA_8888;  
        wmParams.flags = LayoutParams.FLAG_NOT_FOCUSABLE ;        
        wmParams.gravity = Gravity.LEFT | Gravity.TOP; 
        wmParams.x = dm.widthPixels;  
        wmParams.y = dm.heightPixels/2; 
        wmParams.width = 60;  
        wmParams.height = 60;  
        LayoutInflater inflater = LayoutInflater.from(getApplication());  
        mFloatLayout = (LinearLayout) inflater.inflate(R.layout.float_window, null); 
        mFloatLayout.setOnTouchListener(new OnTouchListener() {
			
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				x = event.getRawX();
				y = event.getRawY() ; 
				switch (event.getAction()) {
				case MotionEvent.ACTION_DOWN: 
					Log.e("", "ACTION_DOWN");
				mTouchX = event.getX();
				mTouchY = event.getY();
				mStartX = x;
				mStartY = y;
				
				mFloatLayout.setBackground(getResources().getDrawable(R.drawable.bg_close)) ;
				break;
				case MotionEvent.ACTION_MOVE: 
					if ((x - mStartX) < 5 && (y - mStartY) < 5) {
					}
				break;
				case MotionEvent.ACTION_UP: 
					mFloatLayout.setBackground(getResources().getDrawable(R.drawable.bg)) ;
				//鐐瑰嚮鏈夋晥
				if ((x - mStartX) < 5 && (y - mStartY) < 5) {
					Log.e("onclice", "start = " + startFlag) ;
					if(scanConfig.is1D()){
						Intent to1D = new Intent(FloatWindow.this, Scan1DService.class) ;
						startService(to1D) ;
					}else{
						Intent intent = new Intent(FloatWindow.this, ScanService.class) ;
						startService(intent) ;
					}
				}else{
					Log.e("onclice", "finish++++") ;
					updateView();
					mFloatLayout.setBackground(getResources().getDrawable(R.drawable.bg)) ;
					mTouchX = mTouchY = 0;
				}
				break;
				} 
				return true;
			}
		});
      //娣诲姞mFloatLayout  
        wm.addView(mFloatLayout, wmParams);  
        
        
	}
	
	//绉诲姩鎮诞绐楀彛
	private void updateView(){
		wmParams.x = (int)(x - mTouchX);
		wmParams.y = (int)(y - mTouchY);
		wm.updateViewLayout(mFloatLayout, wmParams);
	}
	
	//娉ㄥ唽骞挎挱
	private MReceiver receiver ;
	private void initReceiver(){
		receiver = new MReceiver();
		IntentFilter filter = new IntentFilter("com.example.scanservice.FloatWindow");
		registerReceiver(receiver, filter);
	}
	
	//骞挎挱鎺ユ敹鑰�
	private class MReceiver extends BroadcastReceiver{

		@Override
		public void onReceive(Context context, Intent intent) {
			stopSelf();
		}
		
	}
	
	
	private boolean runFlag = true ;  
	private boolean startFlag = false ; 
	
	private Set<String> hashSetEpc = new HashSet<String>() ;
	
	class InventoryThread extends Thread{
		private List<String> epcList;

		@Override
		public void run() {
			super.run();
			Log.e("InventoryThread	", "start()");
			while(runFlag){
				
				if(startFlag ){
//					reader.stopInventoryMulti()
//					epcList = reader.inventoryTag(); //实时锟教达拷
					if(epcList != null && !epcList.isEmpty()){
						//锟斤拷锟斤拷锟斤拷示锟斤拷
						
						for(String epc:epcList){
							Log.e("epc	", "" + epc);
							if(epcSet.isEmpty() || !epcSet.contains(epc)){
								epcSet.add(epc) ;
								sendMSG(epc) ;
							}
							
//							String epcStr = new String(epc);
//							addToList(listEPC, epc);
							
						}
					}
					epcList = null ;
					try {
						Thread.sleep(20);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	
	private static final int MSG_UHF = 1102 ;
	private static final String KEY_UHF = "uhf" ;
	private void sendMSG(String msg){
		Util.play(1, 0);
		Message message = new Message() ;
		message.what = MSG_UHF ; 
		Bundle bundle = new Bundle() ;
		bundle.putString(KEY_UHF, msg) ;
		message.setData(bundle) ;
		handler.sendMessage(message) ;
	}
	

}
