package cn.pda.scan;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import cn.pda.serialport.SerialPort;

public class ScanThread extends Thread {
	
	private SerialPort mSerialPort ;
	private InputStream is ;
	private OutputStream os ;
	/*serialport parameter*/
	private int port = 3;
	private int baudrate = 9600;
	private int flags = 0;
	
	private Handler handler ;
	
	
	public static final int SCAN = 1001;  //messege recv mode
	public static int SWITCH_INPUT = 1002 ;//鍒囨崲杈撳叆娉�
	

	
	/**
	 * if throw exception, serialport initialize fail.
	 * @throws SecurityException
	 * @throws IOException
	 */
	public ScanThread(Handler handler) throws SecurityException, IOException{
		this.handler = handler;
		mSerialPort = new SerialPort(port, baudrate, flags);
		
		is = mSerialPort.getInputStream();
		os = mSerialPort.getOutputStream();
//		mSerialPort.scaner_trigoff();
		mSerialPort.scaner_poweron();
		mSerialPort.scaner_trigoff() ;
		try {
			Thread.sleep(500);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		/** clear useless data **/
		byte[] temp = new byte[128];
		is.read(temp);
		
	}
	
	@Override
	public void run() {
		try {
			int size = 0;
			byte[] buffer = new byte[4096];
			int available = 0;
			while(!isInterrupted()){
				available = is.available();
				if(available > 0){
					try {
						Thread.sleep(30);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					size = is.read(buffer);
					if(size > 0){
						sendMessege(buffer, size, SCAN);
						if(mtimer != null){
							mtimer.cancel();
						}
					}
				}
			}
		} catch (IOException e) {
			//锟斤拷锟截达拷锟斤拷锟斤拷息
			e.printStackTrace();
		}
		super.run();
	}
	
	
	private final byte START = 0x02 ;
	private final byte END = 0x03 ;
	private void sendMessege(byte[] data, int dataLen, int mode){
			String dataStr = "";
			if(data != null && dataLen > 0){
				dataStr = new String(data,0, dataLen );
				dataStr = dataStr.replaceAll("\r\n", "");
			}
			Bundle bundle = new Bundle();
			bundle.putString("data", dataStr);
			Message msg = new Message();
			msg.what = mode;
			msg.setData(bundle);
			handler.sendMessage(msg);
//		}

	}
	
	Timer mtimer = null;
	
	public void scan(){
		mSerialPort.scaner_poweron() ;
		try{
			Thread.sleep(10) ;
		}catch(Exception e){
			
		}
		
		if(mtimer != null){
			mtimer.cancel();
		}
		mtimer = new Timer();
		mtimer.schedule(new TimerTask() {
			
			@Override
			public void run() {
				mSerialPort.scaner_trigoff();
				//鍒囨崲杈撳叆娉�
				sendMessege(null, 0, SWITCH_INPUT);
			}
		}, 5000);
		if(mSerialPort.scaner_trig_stat() == true){
			mSerialPort.scaner_trigoff();
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		mSerialPort.scaner_trigon();
	}
	
	public void close(){
		if(mSerialPort != null){
			mSerialPort.scaner_poweroff();
			try {
			if(is != null){
				is.close();
			}
			if(os != null){
				os.close();
			}
			} catch (IOException e) {
				e.printStackTrace();
			}
			mSerialPort.close(port);
		}
	}

}
