package com.example.uhfservice;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.pda.hf.HFReader;
import com.pda.hf.ISO15693CardInfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import cn.pda.serialport.Tools;

public class UHFThread extends Thread {
	private HFReader reader;
	private boolean startFlag = false;
	private boolean runFlag = true;
	private Handler handler ;
	private ScanConfig config;
	public static int UHF = 1001;  // messege recv mode
	
	/**
	 * if throw exception, serialport initialize fail.
	 * @throws SecurityException
	 * @throws IOException
	 */
	private Context mContext;
	public UHFThread(Handler handler, Context context) throws SecurityException, IOException {
		mContext = context;
		config = new ScanConfig(mContext);
		this.handler = handler;
		reader = new HFReader(14,115200,HFReader.POWER_PSAM);
		if(reader == null)
			return;
		Log.e("UHFThread", "init lf success");
		try {
			Thread.sleep(150);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
//		reader.setWorkArea(3);
	}
	
	private List<String> mydatamodel = new ArrayList<String>();
	@Override
	public void run() {
		super.run();
		while (runFlag) {
//			Lf134kDataModel datamodel = reader.GetData(1000);
			byte[] uid = reader.search14443Acard();
			if (uid==null){
				List<ISO15693CardInfo> list = reader.search15693Card();
				if (list!=null&&list.size()>0) uid = list.get(0).getUid();
			}
			Log.e("run", "running");
			if (startFlag) {
				Log.e("run", "starting");

				try {
//					Lf134kDataModel datamodel = reader.GetData(startFlag, 100);
				if (uid != null ) {
					if (!config.isRepeat()) {
						byte[] e = uid;
						String est = Tools.Bytes2HexString(e,e.length)+"";
//						boolean contain = false;
//						for (int i = 0; i < mydatamodel.size(); i++) {
//							Log.e("epc"+i, mydatamodel.get(i));
//						}
						if (mydatamodel.contains(est)) {
//							Log.e("repeat", config.isRepeat()+"contains");
						}else {
							
							sendMessege(e, UHF);
							mydatamodel.add(est);
						}
					}else {
						byte[] e = uid;
//						String ee = Tools.Bytes2HexString(e, e.length);
						
						sendMessege(e, UHF);
					}
					
					if (!config.isCirculate()) {
						startFlag = false;
					}
				}
				} catch (NullPointerException e) {
					e.printStackTrace();
				}
			}
		}
	}
	private void sendMessege(byte[] data, int mode){


		String dataStr = Tools.BytesToLong(data)+"";
		int datalent = dataStr.length();
		Bundle bundle = new Bundle();
		bundle.putString("data", dataStr);
		if (config.isCirculate()) {
			bundle.putString("c", mydatamodel.size()+"");
		}else {
			bundle.putString("c", "1");
		}
		Message msg = new Message();
		msg.what = mode;
		msg.setData(bundle);
		handler.sendMessage(msg);
	}
//	private void sendMessege(byte[] nation,byte[] data, int mode){
//
////		String nationStr = Tools.BytesToLong(nation)+"";
//
//		String dataStr = Tools.BytesToLong(data)+"";
//		int datalent = dataStr.length();
////		int nationlent = nationStr.length();
////		for (int i = 0; i < 12-datalent; i++) {
////			dataStr = "0"+dataStr;
////		}
////		for (int j = 0; j < 3-nationlent; j++) {
////			nationStr = "0"+nationStr;
////		}
//
//		Bundle bundle = new Bundle();
//		bundle.putString("data", nationStr+dataStr);
//		Log.e("data", nationStr);
//		if (config.isCirculate()) {
//			bundle.putString("c", mydatamodel.size()+"");
//		}else {
//			bundle.putString("c", "1");
//		}
//		Message msg = new Message();
//		msg.what = mode;
//		msg.setData(bundle);
//		handler.sendMessage(msg);
//	}
	
	/**
	 * EEEE11113333FFFF
	 * AAAA
	 * AFFF201607251514AFFF
	 * */
	
	
	private Timer mTimer = null;
	private Timer mTimer2 = null;
	public void scan(){
		Log.e("UHFThread", "scan");
		mydatamodel.removeAll(mydatamodel);
		startFlag = true;
		if(mTimer != null){
			mTimer.cancel();
			mTimer = null;
		}
		mTimer = new Timer();
		mTimer.schedule(new TimerTask() {
			@Override
			public void run() {
				startFlag = false;
			}
		}, config.getTime()*1000);
//		if(mTimer2 != null){
//			mTimer2.cancel();
//			mTimer2 = null;
//		}
//		mTimer2 = new Timer();
//		mTimer2.schedule(new TimerTask() {			
//			@Override
//			public void run() {
//				if (!config.isCirculate()) {
//					UHFService.Close();
//				}
////				Log.e("�Զ��ر�", "�Զ�");
//			}
//		}, 60*1000);
	}
	
	public void close(){
		reader.close(14);
		startFlag = false;
		runFlag = false;

	}
	
	public void sendTo(String data ){
		
		Intent toBack = new Intent() ;
		toBack.setAction("android.rfid.INPUT") ;
		toBack.putExtra("data", data) ;
		toBack.putExtra("enter", true) ;
		mContext.sendBroadcast(toBack) ;
	}
	
}
