/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.UHF;

import com.handheld.UHF.CommendManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class NewSendCommendManager
implements CommendManager {
    private InputStream in;
    private OutputStream out;
    private final byte HEAD = (byte)-69;
    private final byte END = (byte)126;
    public static final byte RESPONSE_OK = 0;
    public static final byte ERROR_CODE_ACCESS_FAIL = 22;
    public static final byte ERROR_CODE_NO_CARD = 9;
    public static final byte ERROR_CODE_READ_SA_OR_LEN_ERROR = -93;
    public static final byte ERROR_CODE_WRITE_SA_OR_LEN_ERROR = -77;
    public static final int SENSITIVE_HIHG = 3;
    public static final int SENSITIVE_MIDDLE = 2;
    public static final int SENSITIVE_LOW = 1;
    public static final int SENSITIVE_VERY_LOW = 0;
    private byte[] selectEPC = null;

    public NewSendCommendManager(InputStream serialPortInput, OutputStream serialportOutput) {
        this.in = serialPortInput;
        this.out = serialportOutput;
    }

    private void sendCMD(byte[] cmd) {
        try {
            this.out.write(cmd);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setBaudrate() {
        byte[] cmd = new byte[]{};
        return false;
    }

    @Override
    public byte[] getFirmware() {
        byte[] resolve;
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = 3;
        byArray[4] = 1;
        byArray[6] = 4;
        byArray[7] = 126;
        byte[] cmd = byArray;
        byte[] version = null;
        this.sendCMD(cmd);
        byte[] response = this.read();
        if (response != null && (resolve = this.handlerResponse(response)) != null && resolve.length > 1) {
            version = new byte[resolve.length - 1];
            System.arraycopy(resolve, 1, version, 0, resolve.length - 1);
        }
        return version;
    }

    @Override
    public void setSensitivity(int value) {
        byte[] byArray = new byte[11];
        byArray[0] = -69;
        byArray[2] = -16;
        byArray[4] = 4;
        byArray[5] = 2;
        byArray[6] = 6;
        byArray[8] = -96;
        byArray[9] = -100;
        byArray[10] = 126;
        byte[] cmd = byArray;
        cmd[5] = (byte)value;
        cmd[cmd.length - 2] = this.checkSum(cmd);
        this.sendCMD(cmd);
        byte[] response = this.read();
        if (response != null) {
            // empty if block
        }
    }

    private byte[] read() {
        byte[] responseData = null;
        byte[] response = null;
        int available = 0;
        int index = 0;
        int headIndex = 0;
        try {
            while (index < 10) {
                Thread.sleep(50L);
                available = this.in.available();
                if (available > 7) break;
                ++index;
            }
            if (available > 0) {
                responseData = new byte[available];
                this.in.read(responseData);
                int i = 0;
                while (i < available) {
                    if (responseData[i] == -69) {
                        headIndex = i;
                        break;
                    }
                    ++i;
                }
                response = new byte[available - headIndex];
                System.arraycopy(responseData, headIndex, response, 0, response.length);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return response;
    }

    @Override
    public boolean setOutputPower(int value) {
        int mixer = 1;
        int if_g = 3;
        int trd = 432;
        switch (value) {
            case 16: {
                mixer = 1;
                if_g = 1;
                trd = 432;
                break;
            }
            case 17: {
                mixer = 1;
                if_g = 3;
                trd = 432;
                break;
            }
            case 18: {
                mixer = 2;
                if_g = 4;
                trd = 432;
                break;
            }
            case 19: {
                mixer = 2;
                if_g = 5;
                trd = 496;
            }
            case 20: {
                mixer = 2;
                if_g = 6;
                trd = 496;
            }
            case 21: {
                mixer = 2;
                if_g = 6;
                trd = 560;
                break;
            }
            case 22: {
                mixer = 3;
                if_g = 6;
                trd = 624;
                break;
            }
            case 23: {
                mixer = 4;
                if_g = 6;
                trd = 624;
                break;
            }
            default: {
                mixer = 6;
                if_g = 7;
                trd = 624;
            }
        }
        return this.setRecvParam(mixer, if_g, trd);
    }

    public boolean setRecvParam(int mixer_g, int if_g, int trd) {
        byte[] byArray = new byte[11];
        byArray[0] = -69;
        byArray[2] = -16;
        byArray[4] = 4;
        byArray[5] = 3;
        byArray[6] = 6;
        byArray[7] = 1;
        byArray[8] = -80;
        byArray[9] = -82;
        byArray[10] = 126;
        byte[] cmd = byArray;
        byte[] recv = null;
        byte[] content = null;
        cmd[5] = (byte)mixer_g;
        cmd[6] = (byte)if_g;
        cmd[7] = (byte)(trd / 256);
        cmd[8] = (byte)(trd % 256);
        cmd[9] = this.checkSum(cmd);
        this.sendCMD(cmd);
        recv = this.read();
        return recv != null && (content = this.handlerResponse(recv)) != null;
    }

    public List<byte[]> inventoryMulti() {
        this.unSelectEPC();
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] byArray = new byte[10];
        byArray[0] = -69;
        byArray[2] = 39;
        byArray[4] = 3;
        byArray[5] = 34;
        byArray[6] = 39;
        byArray[7] = 16;
        byArray[8] = -125;
        byArray[9] = 126;
        byte[] cmd = byArray;
        this.sendCMD(cmd);
        byte[] response = this.read();
        if (response != null) {
            int responseLength = response.length;
            int start = 0;
            if (responseLength > 15) {
                while (responseLength > 5) {
                    int paraLen = response[start + 4] & 0xFF;
                    int singleCardLen = paraLen + 7;
                    if (singleCardLen <= responseLength) {
                        byte[] sigleCard = new byte[singleCardLen];
                        System.arraycopy(response, start, sigleCard, 0, singleCardLen);
                        byte[] resolve = this.handlerResponse(sigleCard);
                        if (resolve != null && paraLen > 5) {
                            byte[] epcBytes = new byte[paraLen - 5];
                            System.arraycopy(resolve, 4, epcBytes, 0, paraLen - 5);
                            list.add(epcBytes);
                        }
                        start += singleCardLen;
                        responseLength -= singleCardLen;
                        continue;
                    }
                    break;
                }
            } else {
                this.handlerResponse(response);
            }
        }
        return list;
    }

    public void stopInventoryMulti() {
        byte[] byArray = new byte[7];
        byArray[0] = -69;
        byArray[2] = 40;
        byArray[5] = 40;
        byArray[6] = 126;
        byte[] cmd = byArray;
        this.sendCMD(cmd);
        byte[] recv = this.read();
    }

    @Override
    public List<byte[]> inventoryRealTime() {
        this.unSelectEPC();
        byte[] byArray = new byte[7];
        byArray[0] = -69;
        byArray[2] = 34;
        byArray[5] = 34;
        byArray[6] = 126;
        byte[] cmd = byArray;
        this.sendCMD(cmd);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] response = this.read();
        if (response != null) {
            int responseLength = response.length;
            int start = 0;
            if (responseLength > 15) {
                while (responseLength > 5) {
                    int paraLen = response[start + 4] & 0xFF;
                    int singleCardLen = paraLen + 7;
                    if (singleCardLen <= responseLength) {
                        byte[] sigleCard = new byte[singleCardLen];
                        System.arraycopy(response, start, sigleCard, 0, singleCardLen);
                        byte[] resolve = this.handlerResponse(sigleCard);
                        if (resolve != null && paraLen > 5) {
                            byte[] epcBytes = new byte[paraLen - 5];
                            System.arraycopy(resolve, 4, epcBytes, 0, paraLen - 5);
                            list.add(epcBytes);
                        }
                        start += singleCardLen;
                        responseLength -= singleCardLen;
                        continue;
                    }
                    break;
                }
            } else {
                this.handlerResponse(response);
            }
        }
        return list;
    }

    @Override
    public void selectEPC(byte[] epc) {
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = 18;
        byArray[4] = 1;
        byArray[6] = 19;
        byArray[7] = 126;
        byte[] cmd = byArray;
        this.selectEPC = epc;
        this.sendCMD(cmd);
        byte[] response = this.read();
    }

    public int unSelectEPC() {
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = 18;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 20;
        byArray[7] = 126;
        byte[] cmd = byArray;
        this.sendCMD(cmd);
        byte[] response = this.read();
        return 0;
    }

    private void setSelectPara() {
        byte[] byArray = new byte[26];
        byArray[0] = -69;
        byArray[2] = 12;
        byArray[4] = 19;
        byArray[5] = 1;
        byArray[9] = 32;
        byArray[10] = 96;
        byArray[12] = 1;
        byArray[13] = 97;
        byArray[14] = 5;
        byArray[15] = -72;
        byArray[16] = 3;
        byArray[17] = 72;
        byArray[18] = 12;
        byArray[19] = -48;
        byArray[21] = 3;
        byArray[22] = -47;
        byArray[23] = -98;
        byArray[24] = 88;
        byArray[25] = 126;
        byte[] cmd = byArray;
        if (this.selectEPC != null) {
            System.arraycopy(this.selectEPC, 0, cmd, 12, this.selectEPC.length);
            cmd[cmd.length - 2] = this.checkSum(cmd);
            this.sendCMD(cmd);
            byte[] byArray2 = this.read();
        }
    }

    @Override
    public byte[] readFrom6C(int memBank, int startAddr, int length, byte[] accessPassword) {
        byte[] resolve;
        this.setSelectPara();
        byte[] byArray = new byte[16];
        byArray[0] = -69;
        byArray[2] = 57;
        byArray[4] = 9;
        byArray[9] = 3;
        byArray[13] = 8;
        byArray[14] = 77;
        byArray[15] = 126;
        byte[] cmd = byArray;
        byte[] data = null;
        if (accessPassword == null || accessPassword.length != 4) {
            return null;
        }
        System.arraycopy(accessPassword, 0, cmd, 5, 4);
        cmd[9] = (byte)memBank;
        if (startAddr <= 255) {
            cmd[10] = 0;
            cmd[11] = (byte)startAddr;
        } else {
            int addrH = startAddr / 256;
            int addrL = startAddr % 256;
            cmd[10] = (byte)addrH;
            cmd[11] = (byte)addrL;
        }
        if (length <= 255) {
            cmd[12] = 0;
            cmd[13] = (byte)length;
        } else {
            int lengH = length / 256;
            int lengL = length % 256;
            cmd[12] = (byte)lengH;
            cmd[13] = (byte)lengL;
        }
        cmd[14] = this.checkSum(cmd);
        this.sendCMD(cmd);
        byte[] response = this.read();
        if (response != null && (resolve = this.handlerResponse(response)) != null) {
            if (resolve[0] == 57) {
                int lengData = resolve.length - resolve[1] - 2;
                data = new byte[lengData];
                System.arraycopy(resolve, resolve[1] + 2, data, 0, lengData);
            } else {
                data = new byte[]{resolve[1]};
            }
        }
        return data;
    }

    @Override
    public boolean writeTo6C(byte[] password, int memBank, int startAddr, int dataLen, byte[] data) {
        byte[] resolve;
        this.setSelectPara();
        if (password == null || password.length != 4) {
            return false;
        }
        boolean writeFlag = false;
        int cmdLen = 16 + data.length;
        int parameterLen = 9 + data.length;
        byte[] cmd = new byte[cmdLen];
        cmd[0] = -69;
        cmd[1] = 0;
        cmd[2] = 73;
        if (parameterLen < 256) {
            cmd[3] = 0;
            cmd[4] = (byte)parameterLen;
        } else {
            int paraH = parameterLen / 256;
            int paraL = parameterLen % 256;
            cmd[3] = (byte)paraH;
            cmd[4] = (byte)paraL;
        }
        System.arraycopy(password, 0, cmd, 5, 4);
        cmd[9] = (byte)memBank;
        if (startAddr < 256) {
            cmd[10] = 0;
            cmd[11] = (byte)startAddr;
        } else {
            int startH = startAddr / 256;
            int startL = startAddr % 256;
            cmd[10] = (byte)startH;
            cmd[11] = (byte)startL;
        }
        if (dataLen < 256) {
            cmd[12] = 0;
            cmd[13] = (byte)dataLen;
        } else {
            int dataLenH = dataLen / 256;
            int dataLenL = dataLen % 256;
            cmd[12] = (byte)dataLenH;
            cmd[13] = (byte)dataLenL;
        }
        System.arraycopy(data, 0, cmd, 14, data.length);
        cmd[cmdLen - 2] = this.checkSum(cmd);
        cmd[cmdLen - 1] = 126;
        this.sendCMD(cmd);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] response = this.read();
        if (response != null && (resolve = this.handlerResponse(response)) != null && resolve[0] == 73 && resolve[resolve.length - 1] == 0) {
            writeFlag = true;
        }
        return writeFlag;
    }

    @Override
    public boolean lock6C(byte[] password, int memBank, int lockType) {
        return false;
    }

    @Override
    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte checkSum(byte[] data) {
        byte crc = 0;
        int i = 1;
        while (i < data.length - 2) {
            crc = (byte)(crc + data[i]);
            ++i;
        }
        return crc;
    }

    private byte[] handlerResponse(byte[] response) {
        byte[] data = null;
        byte crc = 0;
        int responseLength = response.length;
        if (response[0] != -69) {
            return data;
        }
        if (response[responseLength - 1] != 126) {
            return data;
        }
        if (responseLength < 7) {
            return data;
        }
        int lengthHigh = response[3] & 0xFF;
        int lengthLow = response[4] & 0xFF;
        int dataLength = lengthHigh * 256 + lengthLow;
        crc = this.checkSum(response);
        if (crc != response[responseLength - 2]) {
            return data;
        }
        if (dataLength != 0 && responseLength == dataLength + 7) {
            data = new byte[dataLength + 1];
            data[0] = response[2];
            System.arraycopy(response, 5, data, 1, dataLength);
        }
        return data;
    }

    @Override
    public int setFrequency(int startFrequency, int freqSpace, int freqQuality) {
        int frequency = 1;
        if (startFrequency > 840125 && startFrequency < 844875) {
            frequency = (startFrequency - 840125) / 250;
        } else if (startFrequency > 920125 && startFrequency < 924875) {
            frequency = (startFrequency - 920125) / 250;
        } else if (startFrequency > 865100 && startFrequency < 867900) {
            frequency = (startFrequency - 865100) / 200;
        } else if (startFrequency > 902250 && startFrequency < 927750) {
            frequency = (startFrequency - 902250) / 500;
        }
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = -85;
        byArray[4] = 1;
        byArray[5] = 4;
        byArray[6] = -80;
        byArray[7] = 126;
        byte[] cmd = byArray;
        cmd[5] = (byte)frequency;
        cmd[6] = this.checkSum(cmd);
        this.sendCMD(cmd);
        byte[] recv = this.read();
        return 0;
    }

    public int setWorkArea(int area) {
        byte[] byArray = new byte[8];
        byArray[0] = -69;
        byArray[2] = 7;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 9;
        byArray[7] = 126;
        byte[] cmd = byArray;
        cmd[5] = (byte)area;
        cmd[6] = this.checkSum(cmd);
        this.sendCMD(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            this.handlerResponse(recv);
        }
        return 0;
    }

    public int getFrequency() {
        byte[] byArray = new byte[7];
        byArray[0] = -69;
        byArray[2] = -86;
        byArray[5] = -86;
        byArray[6] = 126;
        byte[] cmd = byArray;
        this.sendCMD(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            this.handlerResponse(recv);
        }
        return 0;
    }
}

