/*
 * Decompiled with CFR 0.152.
 */
package com.handheld.UHF;

import android.util.Log;
import cn.pda.serialport.Tools;
import com.handheld.UHF.CommendManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SendCommendManager
implements CommendManager {
    private InputStream in;
    private OutputStream out;

    public SendCommendManager() {
    }

    public SendCommendManager(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public boolean setBaudrate() {
        byte[] cmd;
        boolean flag = false;
        cmd = new byte[]{-96, 4, -1, 113, 4, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            if (this.isRecvData(recv) == 0 && Integer.valueOf(recv[3]) == 113 && Integer.valueOf(recv[4]) == 16) {
                flag = true;
            }
        } else {
            Log.i((String)"readFrom6C", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
        }
        return flag;
    }

    @Override
    public byte[] getFirmware() {
        byte[] cmd;
        cmd = new byte[]{-96, 3, 1, 114, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(new String(recv));
        }
        return recv;
    }

    public byte[] getFrequency() {
        byte[] cmd = new byte[]{-96, 3, 1, 121, -29};
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(Tools.Bytes2HexString((byte[])recv, (int)recv.length));
        }
        return null;
    }

    @Override
    public int setFrequency(int startFrequency, int freqSpace, int freqQuality) {
        byte[] cmd;
        cmd = new byte[]{-96, 9, 1, 120, 4, (byte)(freqSpace / 10), (byte)freqQuality, (byte)((0xFF0000 & startFrequency) >> 16), (byte)((0xFF00 & startFrequency) >> 8), (byte)(0xFF & startFrequency), this.checkSum(cmd, cmd.length - 1)};
        System.out.println(Tools.Bytes2HexString((byte[])cmd, (int)cmd.length));
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            System.out.println(Tools.Bytes2HexString((byte[])recv, (int)recv.length));
        }
        return 0;
    }

    public void setWorkAntenna() {
        byte[] cmd;
        cmd = new byte[]{-96, 4, 1, 116, 0, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
    }

    @Override
    public boolean setOutputPower(int value) {
        byte[] cmd;
        cmd = new byte[]{-96, 4, 1, 118, (byte)value, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        this.read();
        return true;
    }

    @Override
    public List<byte[]> inventoryRealTime() {
        byte[] cmd;
        ArrayList<byte[]> epcList = new ArrayList<byte[]>();
        cmd = new byte[]{-96, 4, 1, -119, 1, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        Log.i((String)"", (String)"send inventory real time***");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int length = recv.length;
            ArrayList srcData = new ArrayList();
            int start = 0;
            while (length > 0) {
                if (recv[start] == -96) {
                    int dataLen = recv[start + 1] & 0xFF;
                    byte[] data = new byte[dataLen + 2];
                    if (data.length > 12 && data.length <= length) {
                        System.arraycopy(recv, start, data, 0, data.length);
                        byte[] epc = new byte[data.length - 9];
                        System.arraycopy(data, 7, epc, 0, data.length - 9);
                        epcList.add(epc);
                    }
                    start += data.length;
                    length -= data.length;
                    continue;
                }
                break;
            }
        } else {
            Log.i((String)"realTimeInventory", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
        }
        return epcList;
    }

    @Override
    public void selectEPC(byte[] epc) {
        int epcLen = epc.length;
        byte[] cmd = new byte[7 + epcLen];
        cmd[0] = -96;
        cmd[1] = 17;
        cmd[2] = 1;
        cmd[3] = -123;
        cmd[4] = 0;
        cmd[5] = 12;
        System.arraycopy(epc, 0, cmd, 6, epcLen);
        cmd[6 + epcLen] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv == null) {
            Log.i((String)"selectEPC", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
        }
    }

    public byte[] readFrom6C(int memBank, int startAddr, int length) {
        byte[] cmd;
        byte[] data = null;
        cmd = new byte[]{-96, 6, 1, -127, (byte)memBank, (byte)startAddr, (byte)length, this.checkSum(cmd, cmd.length - 1)};
        this.sendToReader(cmd);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int len = recv.length;
            if (recv[0] != -96) {
                return data;
            }
            byte check = this.checkSum(recv, len - 1);
            if (check != recv[len - 1]) {
                Log.i((String)"read data ", (String)"checksum error");
                return data;
            }
            if (len == 6) {
                Log.i((String)"read data ", (String)"read fail!!");
                return data;
            }
            int tagCount = (recv[4] & 0xFF) * 256 + (recv[5] & 0xFF);
            int dataLen = recv[6] & 0xFF;
            byte readLen = recv[len - 4];
            int epcLen = dataLen - readLen - 4;
            if (dataLen <= readLen || dataLen < epcLen || epcLen < 0) {
                return data;
            }
            data = new byte[readLen + epcLen];
            System.arraycopy(recv, 9, data, 0, epcLen);
            System.arraycopy(recv, 11 + epcLen, data, epcLen, readLen);
        } else {
            Log.i((String)"read data ", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
        }
        return data;
    }

    @Override
    public byte[] readFrom6C(int memBank, int startAddr, int length, byte[] password) {
        byte[] data = null;
        byte[] cmd = new byte[12];
        cmd[0] = -96;
        cmd[1] = 10;
        cmd[2] = 1;
        cmd[3] = -127;
        cmd[4] = (byte)memBank;
        cmd[5] = (byte)startAddr;
        cmd[6] = (byte)length;
        if (password.length != 4) {
            Log.e((String)"readFrom6C", (String)"password error");
            return null;
        }
        cmd[7] = password[0];
        cmd[8] = password[1];
        cmd[9] = password[2];
        cmd[10] = password[3];
        cmd[11] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int len = recv.length;
            if (recv[0] != -96) {
                return data;
            }
            byte check = this.checkSum(recv, len - 1);
            if (check != recv[len - 1]) {
                Log.i((String)"read data ", (String)"checksum error");
                return data;
            }
            if (len == 6) {
                Log.i((String)"read data ", (String)"read fail!!");
                return data;
            }
            int tagCount = (recv[4] & 0xFF) * 256 + (recv[5] & 0xFF);
            int dataLen = recv[6] & 0xFF;
            byte readLen = recv[len - 4];
            int epcLen = dataLen - readLen - 4;
            if (dataLen <= readLen || dataLen < epcLen || epcLen < 0) {
                return data;
            }
            if (recv.length < epcLen + 9) {
                return data;
            }
            data = new byte[readLen + epcLen];
            System.arraycopy(recv, 9, data, 0, epcLen);
            System.arraycopy(recv, 11 + epcLen, data, epcLen, readLen);
        } else {
            Log.i((String)"read data ", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
        }
        return data;
    }

    @Override
    public boolean writeTo6C(byte[] password, int memBank, int wordAdd, int dataLen, byte[] data) {
        boolean writeFlag = false;
        int cmdLen = 12 + (dataLen /= 2) * 2;
        byte[] cmd = new byte[cmdLen];
        cmd[0] = -96;
        cmd[1] = (byte)(cmdLen - 2);
        cmd[2] = 1;
        cmd[3] = -126;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = (byte)memBank;
        cmd[9] = (byte)wordAdd;
        cmd[10] = (byte)dataLen;
        System.arraycopy(data, 0, cmd, 11, data.length);
        cmd[11 + data.length] = this.checkSum(cmd, 11 + data.length);
        this.sendToReader(cmd);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        byte[] recv = this.read();
        if (recv != null) {
            int recvLength = recv.length;
            if (recvLength == 6) {
                return writeFlag;
            }
            if (this.isRecvData(recv) == 0) {
                writeFlag = true;
            }
        } else {
            Log.i((String)"write data", (String)"\u6307\u951f\u7b4b\u8d85\u65f6");
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.read();
        }
        return writeFlag;
    }

    @Override
    public boolean lock6C(byte[] password, int memBank, int lockType) {
        boolean lockFlag = false;
        byte[] cmd = new byte[11];
        cmd[0] = -96;
        cmd[1] = 9;
        cmd[2] = 1;
        cmd[3] = -125;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = (byte)memBank;
        cmd[9] = (byte)lockType;
        cmd[10] = this.checkSum(cmd, cmd.length - 1);
        this.sendToReader(cmd);
        byte[] recv = this.read();
        if (recv != null) {
            if (recv.length == 6) {
                return lockFlag;
            }
            if (this.isRecvData(recv) == 0) {
                lockFlag = true;
            }
        } else {
            Log.i((String)"Lock..6c", (String)"\u951f\u65a4\u62f7\u65f6");
        }
        return lockFlag;
    }

    @Override
    public boolean kill6C(byte[] password) {
        boolean killFlag = false;
        byte[] cmd = new byte[9];
        cmd[0] = -96;
        cmd[1] = 7;
        cmd[2] = -1;
        cmd[3] = -124;
        System.arraycopy(password, 0, cmd, 4, password.length);
        cmd[8] = this.checkSum(cmd, cmd.length - 1);
        byte[] recv = this.read();
        if (recv != null) {
            if (recv.length == 6) {
                return killFlag;
            }
            if (this.isRecvData(recv) == 0) {
                killFlag = true;
            }
        } else {
            Log.i((String)"Kill ***", (String)"\u951f\u65a4\u62f7\u65f6");
        }
        return killFlag;
    }

    public void inventory6B() {
        byte[] byArray = new byte[5];
        byArray[0] = -96;
        byArray[1] = 3;
        byArray[2] = 1;
        byArray[3] = -80;
        byte[] cmd = byArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] read() {
        count = 0;
        index = 0;
        allCount = 0;
        resp = null;
        try {
            while (true) {
                block7: {
                    if (count < 3) break block7;
                    Thread.sleep(50L);
                    allCount = this.in.available();
                    resp = new byte[allCount];
                    Log.i((String)"read allCount****", (String)String.valueOf(allCount));
                    mcount = 0;
                    if (true) ** GOTO lbl44
                }
                count = this.in.available();
                if (index > 50) {
                    return null;
                }
                ++index;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception var5_7) {
            // empty catch block
        }
        return resp;
        do {
            bytes = new byte[2];
            this.in.read(bytes);
            length = bytes[1];
            count = 0;
            count = this.in.available();
            Log.i((String)"read count", (String)String.valueOf(count));
            data = new byte[length];
            dataSize = this.in.read(data);
            System.arraycopy(bytes, 0, resp, mcount, 2);
            System.arraycopy(data, 0, resp, mcount + 2, length);
            mcount = mcount + 2 + length;
            count = this.in.available();
lbl44:
            // 2 sources

        } while (count != 0);
        return resp;
    }

    public boolean sendToReader(byte[] cmd) {
        try {
            this.out.write(cmd);
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public byte checkSum(byte[] uBuff, int uBuffLen) {
        byte crc = 0;
        int i = 0;
        while (i < uBuffLen) {
            crc = (byte)(crc + uBuff[i]);
            ++i;
        }
        crc = (byte)(0xFF & ~crc + 1);
        return crc;
    }

    public int isRecvData(byte[] recv) {
        if (recv.length < 5) {
            return -1;
        }
        String data = Tools.Bytes2HexString((byte[])recv, (int)recv.length);
        if (recv[0] != -96) {
            return -2;
        }
        int recvDataLen = Integer.parseInt(data.substring(2, 4), 16);
        if (recvDataLen != recv.length - 2) {
            return -3;
        }
        byte crc = this.checkSum(recv, recv.length - 1);
        if (crc != recv[recv.length - 1]) {
            return -4;
        }
        return 0;
    }

    @Override
    public void setSensitivity(int value) {
    }

    @Override
    public void close() {
    }

    @Override
    public byte checkSum(byte[] data) {
        return 0;
    }
}

