/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IntDef;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompatEclairMr1;
import android.support.v4.view.ViewCompatGingerbread;
import android.support.v4.view.ViewCompatHC;
import android.support.v4.view.ViewCompatICS;
import android.support.v4.view.ViewCompatJB;
import android.support.v4.view.ViewCompatJellybeanMr1;
import android.support.v4.view.ViewCompatKitKat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityNodeProviderCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class ViewCompat {
    private static final String TAG = "ViewCompat";
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    private static final long FAKE_FRAME_TIME = 10L;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_AUTO = 0;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_YES = 1;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_NO = 2;
    public static final int IMPORTANT_FOR_ACCESSIBILITY_NO_HIDE_DESCENDANTS = 4;
    public static final int ACCESSIBILITY_LIVE_REGION_NONE = 0;
    public static final int ACCESSIBILITY_LIVE_REGION_POLITE = 1;
    public static final int ACCESSIBILITY_LIVE_REGION_ASSERTIVE = 2;
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 1;
    public static final int LAYOUT_DIRECTION_INHERIT = 2;
    public static final int LAYOUT_DIRECTION_LOCALE = 3;
    public static final int MEASURED_SIZE_MASK = 0xFFFFFF;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    static final ViewCompatImpl IMPL;

    public static boolean canScrollHorizontally(View v, int direction) {
        return IMPL.canScrollHorizontally(v, direction);
    }

    public static boolean canScrollVertically(View v, int direction) {
        return IMPL.canScrollVertically(v, direction);
    }

    public static int getOverScrollMode(View v) {
        return IMPL.getOverScrollMode(v);
    }

    public static void setOverScrollMode(View v, int overScrollMode) {
        IMPL.setOverScrollMode(v, overScrollMode);
    }

    public static void onPopulateAccessibilityEvent(View v, AccessibilityEvent event) {
        IMPL.onPopulateAccessibilityEvent(v, event);
    }

    public static void onInitializeAccessibilityEvent(View v, AccessibilityEvent event) {
        IMPL.onInitializeAccessibilityEvent(v, event);
    }

    public static void onInitializeAccessibilityNodeInfo(View v, AccessibilityNodeInfoCompat info) {
        IMPL.onInitializeAccessibilityNodeInfo(v, info);
    }

    public static void setAccessibilityDelegate(View v, AccessibilityDelegateCompat delegate) {
        IMPL.setAccessibilityDelegate(v, delegate);
    }

    public static boolean hasTransientState(View view) {
        return IMPL.hasTransientState(view);
    }

    public static void setHasTransientState(View view, boolean hasTransientState) {
        IMPL.setHasTransientState(view, hasTransientState);
    }

    public static void postInvalidateOnAnimation(View view) {
        IMPL.postInvalidateOnAnimation(view);
    }

    public static void postInvalidateOnAnimation(View view, int left, int top, int right, int bottom) {
        IMPL.postInvalidateOnAnimation(view, left, top, right, bottom);
    }

    public static void postOnAnimation(View view, Runnable action) {
        IMPL.postOnAnimation(view, action);
    }

    public static void postOnAnimationDelayed(View view, Runnable action, long delayMillis) {
        IMPL.postOnAnimationDelayed(view, action, delayMillis);
    }

    public static int getImportantForAccessibility(View view) {
        return IMPL.getImportantForAccessibility(view);
    }

    public static void setImportantForAccessibility(View view, int mode) {
        IMPL.setImportantForAccessibility(view, mode);
    }

    public static boolean performAccessibilityAction(View view, int action, Bundle arguments) {
        return IMPL.performAccessibilityAction(view, action, arguments);
    }

    public static AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View view) {
        return IMPL.getAccessibilityNodeProvider(view);
    }

    public static float getAlpha(View view) {
        return IMPL.getAlpha(view);
    }

    public static void setLayerType(View view, int layerType, Paint paint) {
        IMPL.setLayerType(view, layerType, paint);
    }

    public static int getLayerType(View view) {
        return IMPL.getLayerType(view);
    }

    public static int getLabelFor(View view) {
        return IMPL.getLabelFor(view);
    }

    public static void setLabelFor(View view, int labeledId) {
        IMPL.setLabelFor(view, labeledId);
    }

    public static void setLayerPaint(View view, Paint paint) {
        IMPL.setLayerPaint(view, paint);
    }

    public static int getLayoutDirection(View view) {
        return IMPL.getLayoutDirection(view);
    }

    public static void setLayoutDirection(View view, int layoutDirection) {
        IMPL.setLayoutDirection(view, layoutDirection);
    }

    public static ViewParent getParentForAccessibility(View view) {
        return IMPL.getParentForAccessibility(view);
    }

    public static boolean isOpaque(View view) {
        return IMPL.isOpaque(view);
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        return IMPL.resolveSizeAndState(size, measureSpec, childMeasuredState);
    }

    public static int getMeasuredWidthAndState(View view) {
        return IMPL.getMeasuredWidthAndState(view);
    }

    public static int getMeasuredHeightAndState(View view) {
        return IMPL.getMeasuredHeightAndState(view);
    }

    public static int getMeasuredState(View view) {
        return IMPL.getMeasuredState(view);
    }

    public static int getAccessibilityLiveRegion(View view) {
        return IMPL.getAccessibilityLiveRegion(view);
    }

    public static void setAccessibilityLiveRegion(View view, int mode) {
        IMPL.setAccessibilityLiveRegion(view, mode);
    }

    public static int getPaddingStart(View view) {
        return IMPL.getPaddingStart(view);
    }

    public static int getPaddingEnd(View view) {
        return IMPL.getPaddingEnd(view);
    }

    public static void setPaddingRelative(View view, int start, int top, int end, int bottom) {
        IMPL.setPaddingRelative(view, start, top, end, bottom);
    }

    public static void dispatchStartTemporaryDetach(View view) {
        IMPL.dispatchStartTemporaryDetach(view);
    }

    public static void dispatchFinishTemporaryDetach(View view) {
        IMPL.dispatchFinishTemporaryDetach(view);
    }

    public static float getTranslationX(View view) {
        return IMPL.getTranslationX(view);
    }

    public static float getTranslationY(View view) {
        return IMPL.getTranslationY(view);
    }

    public static int getMinimumWidth(View view) {
        return IMPL.getMinimumWidth(view);
    }

    public static int getMinimumHeight(View view) {
        return IMPL.getMinimumHeight(view);
    }

    public static ViewPropertyAnimatorCompat animate(View view) {
        return IMPL.animate(view);
    }

    public static void setTranslationX(View view, float value) {
        IMPL.setTranslationX(view, value);
    }

    public static void setTranslationY(View view, float value) {
        IMPL.setTranslationY(view, value);
    }

    public static void setAlpha(View view, float value) {
        IMPL.setAlpha(view, value);
    }

    public static void setX(View view, float value) {
        IMPL.setX(view, value);
    }

    public static void setY(View view, float value) {
        IMPL.setY(view, value);
    }

    public static void setRotation(View view, float value) {
        IMPL.setRotation(view, value);
    }

    public static void setRotationX(View view, float value) {
        IMPL.setRotationX(view, value);
    }

    public static void setRotationY(View view, float value) {
        IMPL.setRotationY(view, value);
    }

    public static void setScaleX(View view, float value) {
        IMPL.setScaleX(view, value);
    }

    public static void setScaleY(View view, float value) {
        IMPL.setScaleY(view, value);
    }

    public float getPivotX(View view) {
        return IMPL.getPivotX(view);
    }

    public void setPivotX(View view, float value) {
        IMPL.setPivotX(view, value);
    }

    public float getPivotY(View view) {
        return IMPL.getPivotY(view);
    }

    public void setPivotY(View view, float value) {
        IMPL.setPivotX(view, value);
    }

    public float getRotation(View view) {
        return IMPL.getRotation(view);
    }

    public float getRotationX(View view) {
        return IMPL.getRotationX(view);
    }

    public float getRotationY(View view) {
        return IMPL.getRotationY(view);
    }

    public float getScaleX(View view) {
        return IMPL.getScaleX(view);
    }

    public float getScaleY(View view) {
        return IMPL.getScaleY(view);
    }

    public float getX(View view) {
        return IMPL.getX(view);
    }

    public float getY(View view) {
        return IMPL.getY(view);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 19 ? new KitKatViewCompatImpl() : (version >= 17 ? new JbMr1ViewCompatImpl() : (version >= 16 ? new JBViewCompatImpl() : (version >= 14 ? new ICSViewCompatImpl() : (version >= 11 ? new HCViewCompatImpl() : (version >= 9 ? new GBViewCompatImpl() : new BaseViewCompatImpl())))));
    }

    static class KitKatViewCompatImpl
    extends JbMr1ViewCompatImpl {
        KitKatViewCompatImpl() {
        }

        @Override
        public int getAccessibilityLiveRegion(View view) {
            return ViewCompatKitKat.getAccessibilityLiveRegion((View)view);
        }

        @Override
        public void setAccessibilityLiveRegion(View view, int mode) {
            ViewCompatKitKat.setAccessibilityLiveRegion((View)view, (int)mode);
        }

        @Override
        public void setImportantForAccessibility(View view, int mode) {
            ViewCompatJB.setImportantForAccessibility((View)view, (int)mode);
        }
    }

    static class JbMr1ViewCompatImpl
    extends JBViewCompatImpl {
        JbMr1ViewCompatImpl() {
        }

        @Override
        public int getLabelFor(View view) {
            return ViewCompatJellybeanMr1.getLabelFor((View)view);
        }

        @Override
        public void setLabelFor(View view, int id) {
            ViewCompatJellybeanMr1.setLabelFor((View)view, (int)id);
        }

        @Override
        public void setLayerPaint(View view, Paint paint) {
            ViewCompatJellybeanMr1.setLayerPaint((View)view, (Paint)paint);
        }

        @Override
        public int getLayoutDirection(View view) {
            return ViewCompatJellybeanMr1.getLayoutDirection((View)view);
        }

        @Override
        public void setLayoutDirection(View view, int layoutDirection) {
            ViewCompatJellybeanMr1.setLayoutDirection((View)view, (int)layoutDirection);
        }

        @Override
        public int getPaddingStart(View view) {
            return ViewCompatJellybeanMr1.getPaddingStart((View)view);
        }

        @Override
        public int getPaddingEnd(View view) {
            return ViewCompatJellybeanMr1.getPaddingEnd((View)view);
        }

        @Override
        public void setPaddingRelative(View view, int start, int top, int end, int bottom) {
            ViewCompatJellybeanMr1.setPaddingRelative((View)view, (int)start, (int)top, (int)end, (int)bottom);
        }
    }

    static class JBViewCompatImpl
    extends ICSViewCompatImpl {
        JBViewCompatImpl() {
        }

        @Override
        public boolean hasTransientState(View view) {
            return ViewCompatJB.hasTransientState((View)view);
        }

        @Override
        public void setHasTransientState(View view, boolean hasTransientState) {
            ViewCompatJB.setHasTransientState((View)view, (boolean)hasTransientState);
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            ViewCompatJB.postInvalidateOnAnimation((View)view);
        }

        @Override
        public void postInvalidateOnAnimation(View view, int left, int top, int right, int bottom) {
            ViewCompatJB.postInvalidateOnAnimation((View)view, (int)left, (int)top, (int)right, (int)bottom);
        }

        @Override
        public void postOnAnimation(View view, Runnable action) {
            ViewCompatJB.postOnAnimation((View)view, (Runnable)action);
        }

        @Override
        public void postOnAnimationDelayed(View view, Runnable action, long delayMillis) {
            ViewCompatJB.postOnAnimationDelayed((View)view, (Runnable)action, (long)delayMillis);
        }

        @Override
        public int getImportantForAccessibility(View view) {
            return ViewCompatJB.getImportantForAccessibility((View)view);
        }

        @Override
        public void setImportantForAccessibility(View view, int mode) {
            if (mode == 4) {
                mode = 2;
            }
            ViewCompatJB.setImportantForAccessibility((View)view, (int)mode);
        }

        @Override
        public boolean performAccessibilityAction(View view, int action, Bundle arguments) {
            return ViewCompatJB.performAccessibilityAction((View)view, (int)action, (Bundle)arguments);
        }

        @Override
        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View view) {
            Object compat = ViewCompatJB.getAccessibilityNodeProvider((View)view);
            if (compat != null) {
                return new AccessibilityNodeProviderCompat(compat);
            }
            return null;
        }

        @Override
        public ViewParent getParentForAccessibility(View view) {
            return ViewCompatJB.getParentForAccessibility((View)view);
        }

        @Override
        public int getMinimumWidth(View view) {
            return ViewCompatJB.getMinimumWidth((View)view);
        }

        @Override
        public int getMinimumHeight(View view) {
            return ViewCompatJB.getMinimumHeight((View)view);
        }
    }

    static class ICSViewCompatImpl
    extends HCViewCompatImpl {
        ICSViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View v, int direction) {
            return ViewCompatICS.canScrollHorizontally((View)v, (int)direction);
        }

        @Override
        public boolean canScrollVertically(View v, int direction) {
            return ViewCompatICS.canScrollVertically((View)v, (int)direction);
        }

        @Override
        public void onPopulateAccessibilityEvent(View v, AccessibilityEvent event) {
            ViewCompatICS.onPopulateAccessibilityEvent((View)v, (AccessibilityEvent)event);
        }

        @Override
        public void onInitializeAccessibilityEvent(View v, AccessibilityEvent event) {
            ViewCompatICS.onInitializeAccessibilityEvent((View)v, (AccessibilityEvent)event);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View v, AccessibilityNodeInfoCompat info) {
            ViewCompatICS.onInitializeAccessibilityNodeInfo((View)v, (Object)info.getInfo());
        }

        @Override
        public void setAccessibilityDelegate(View v, AccessibilityDelegateCompat delegate) {
            ViewCompatICS.setAccessibilityDelegate((View)v, (Object)delegate.getBridge());
        }

        @Override
        public ViewPropertyAnimatorCompat animate(View view) {
            ViewPropertyAnimatorCompat vpa;
            if (this.mViewPropertyAnimatorCompatMap == null) {
                this.mViewPropertyAnimatorCompatMap = new WeakHashMap();
            }
            if ((vpa = (ViewPropertyAnimatorCompat)this.mViewPropertyAnimatorCompatMap.get(view)) == null) {
                vpa = new ViewPropertyAnimatorCompat(view);
                this.mViewPropertyAnimatorCompatMap.put(view, vpa);
            }
            return vpa;
        }
    }

    static class HCViewCompatImpl
    extends GBViewCompatImpl {
        HCViewCompatImpl() {
        }

        @Override
        long getFrameTime() {
            return ViewCompatHC.getFrameTime();
        }

        @Override
        public float getAlpha(View view) {
            return ViewCompatHC.getAlpha((View)view);
        }

        @Override
        public void setLayerType(View view, int layerType, Paint paint) {
            ViewCompatHC.setLayerType((View)view, (int)layerType, (Paint)paint);
        }

        @Override
        public int getLayerType(View view) {
            return ViewCompatHC.getLayerType((View)view);
        }

        @Override
        public void setLayerPaint(View view, Paint paint) {
            this.setLayerType(view, this.getLayerType(view), paint);
            view.invalidate();
        }

        @Override
        public int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
            return ViewCompatHC.resolveSizeAndState((int)size, (int)measureSpec, (int)childMeasuredState);
        }

        @Override
        public int getMeasuredWidthAndState(View view) {
            return ViewCompatHC.getMeasuredWidthAndState((View)view);
        }

        @Override
        public int getMeasuredHeightAndState(View view) {
            return ViewCompatHC.getMeasuredHeightAndState((View)view);
        }

        @Override
        public int getMeasuredState(View view) {
            return ViewCompatHC.getMeasuredState((View)view);
        }

        @Override
        public float getTranslationX(View view) {
            return ViewCompatHC.getTranslationX((View)view);
        }

        @Override
        public float getTranslationY(View view) {
            return ViewCompatHC.getTranslationY((View)view);
        }

        @Override
        public void setTranslationX(View view, float value) {
            ViewCompatHC.setTranslationX((View)view, (float)value);
        }

        @Override
        public void setTranslationY(View view, float value) {
            ViewCompatHC.setTranslationY((View)view, (float)value);
        }

        @Override
        public void setAlpha(View view, float value) {
            ViewCompatHC.setAlpha((View)view, (float)value);
        }

        @Override
        public void setX(View view, float value) {
            ViewCompatHC.setX((View)view, (float)value);
        }

        @Override
        public void setY(View view, float value) {
            ViewCompatHC.setY((View)view, (float)value);
        }

        @Override
        public void setRotation(View view, float value) {
            ViewCompatHC.setRotation((View)view, (float)value);
        }

        @Override
        public void setRotationX(View view, float value) {
            ViewCompatHC.setRotationX((View)view, (float)value);
        }

        @Override
        public void setRotationY(View view, float value) {
            ViewCompatHC.setRotationY((View)view, (float)value);
        }

        @Override
        public void setScaleX(View view, float value) {
            ViewCompatHC.setScaleX((View)view, (float)value);
        }

        @Override
        public void setScaleY(View view, float value) {
            ViewCompatHC.setScaleY((View)view, (float)value);
        }

        @Override
        public void setPivotX(View view, float value) {
            ViewCompatHC.setPivotX((View)view, (float)value);
        }

        @Override
        public void setPivotY(View view, float value) {
            ViewCompatHC.setPivotY((View)view, (float)value);
        }

        @Override
        public float getX(View view) {
            return ViewCompatHC.getX((View)view);
        }

        @Override
        public float getY(View view) {
            return ViewCompatHC.getY((View)view);
        }

        @Override
        public float getRotation(View view) {
            return ViewCompatHC.getRotation((View)view);
        }

        @Override
        public float getRotationX(View view) {
            return ViewCompatHC.getRotationX((View)view);
        }

        @Override
        public float getRotationY(View view) {
            return ViewCompatHC.getRotationY((View)view);
        }

        @Override
        public float getScaleX(View view) {
            return ViewCompatHC.getScaleX((View)view);
        }

        @Override
        public float getScaleY(View view) {
            return ViewCompatHC.getScaleY((View)view);
        }

        @Override
        public float getPivotX(View view) {
            return ViewCompatHC.getPivotX((View)view);
        }

        @Override
        public float getPivotY(View view) {
            return ViewCompatHC.getPivotY((View)view);
        }
    }

    static class GBViewCompatImpl
    extends EclairMr1ViewCompatImpl {
        GBViewCompatImpl() {
        }

        @Override
        public int getOverScrollMode(View v) {
            return ViewCompatGingerbread.getOverScrollMode((View)v);
        }

        @Override
        public void setOverScrollMode(View v, int mode) {
            ViewCompatGingerbread.setOverScrollMode((View)v, (int)mode);
        }
    }

    static class EclairMr1ViewCompatImpl
    extends BaseViewCompatImpl {
        EclairMr1ViewCompatImpl() {
        }

        @Override
        public boolean isOpaque(View view) {
            return ViewCompatEclairMr1.isOpaque((View)view);
        }
    }

    static class BaseViewCompatImpl
    implements ViewCompatImpl {
        private Method mDispatchStartTemporaryDetach;
        private Method mDispatchFinishTemporaryDetach;
        private boolean mTempDetachBound;
        WeakHashMap<View, ViewPropertyAnimatorCompat> mViewPropertyAnimatorCompatMap = null;

        BaseViewCompatImpl() {
        }

        @Override
        public boolean canScrollHorizontally(View v, int direction) {
            return false;
        }

        @Override
        public boolean canScrollVertically(View v, int direction) {
            return false;
        }

        @Override
        public int getOverScrollMode(View v) {
            return 2;
        }

        @Override
        public void setOverScrollMode(View v, int mode) {
        }

        @Override
        public void setAccessibilityDelegate(View v, AccessibilityDelegateCompat delegate) {
        }

        @Override
        public void onPopulateAccessibilityEvent(View v, AccessibilityEvent event) {
        }

        @Override
        public void onInitializeAccessibilityEvent(View v, AccessibilityEvent event) {
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View v, AccessibilityNodeInfoCompat info) {
        }

        @Override
        public boolean hasTransientState(View view) {
            return false;
        }

        @Override
        public void setHasTransientState(View view, boolean hasTransientState) {
        }

        @Override
        public void postInvalidateOnAnimation(View view) {
            view.invalidate();
        }

        @Override
        public void postInvalidateOnAnimation(View view, int left, int top, int right, int bottom) {
            view.invalidate(left, top, right, bottom);
        }

        @Override
        public void postOnAnimation(View view, Runnable action) {
            view.postDelayed(action, this.getFrameTime());
        }

        @Override
        public void postOnAnimationDelayed(View view, Runnable action, long delayMillis) {
            view.postDelayed(action, this.getFrameTime() + delayMillis);
        }

        long getFrameTime() {
            return 10L;
        }

        @Override
        public int getImportantForAccessibility(View view) {
            return 0;
        }

        @Override
        public void setImportantForAccessibility(View view, int mode) {
        }

        @Override
        public boolean performAccessibilityAction(View view, int action, Bundle arguments) {
            return false;
        }

        @Override
        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View view) {
            return null;
        }

        @Override
        public float getAlpha(View view) {
            return 1.0f;
        }

        @Override
        public void setLayerType(View view, int layerType, Paint paint) {
        }

        @Override
        public int getLayerType(View view) {
            return 0;
        }

        @Override
        public int getLabelFor(View view) {
            return 0;
        }

        @Override
        public void setLabelFor(View view, int id) {
        }

        @Override
        public void setLayerPaint(View view, Paint p) {
        }

        @Override
        public int getLayoutDirection(View view) {
            return 0;
        }

        @Override
        public void setLayoutDirection(View view, int layoutDirection) {
        }

        @Override
        public ViewParent getParentForAccessibility(View view) {
            return view.getParent();
        }

        @Override
        public boolean isOpaque(View view) {
            Drawable bg = view.getBackground();
            if (bg != null) {
                return bg.getOpacity() == -1;
            }
            return false;
        }

        @Override
        public int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
            return View.resolveSize((int)size, (int)measureSpec);
        }

        @Override
        public int getMeasuredWidthAndState(View view) {
            return view.getMeasuredWidth();
        }

        @Override
        public int getMeasuredHeightAndState(View view) {
            return view.getMeasuredHeight();
        }

        @Override
        public int getMeasuredState(View view) {
            return 0;
        }

        @Override
        public int getAccessibilityLiveRegion(View view) {
            return 0;
        }

        @Override
        public void setAccessibilityLiveRegion(View view, int mode) {
        }

        @Override
        public int getPaddingStart(View view) {
            return view.getPaddingLeft();
        }

        @Override
        public int getPaddingEnd(View view) {
            return view.getPaddingRight();
        }

        @Override
        public void setPaddingRelative(View view, int start, int top, int end, int bottom) {
            view.setPadding(start, top, end, bottom);
        }

        @Override
        public void dispatchStartTemporaryDetach(View view) {
            if (!this.mTempDetachBound) {
                this.bindTempDetach();
            }
            if (this.mDispatchStartTemporaryDetach != null) {
                try {
                    this.mDispatchStartTemporaryDetach.invoke((Object)view, new Object[0]);
                }
                catch (Exception e) {
                    Log.d((String)ViewCompat.TAG, (String)"Error calling dispatchStartTemporaryDetach", (Throwable)e);
                }
            } else {
                view.onStartTemporaryDetach();
            }
        }

        @Override
        public void dispatchFinishTemporaryDetach(View view) {
            if (!this.mTempDetachBound) {
                this.bindTempDetach();
            }
            if (this.mDispatchFinishTemporaryDetach != null) {
                try {
                    this.mDispatchFinishTemporaryDetach.invoke((Object)view, new Object[0]);
                }
                catch (Exception e) {
                    Log.d((String)ViewCompat.TAG, (String)"Error calling dispatchFinishTemporaryDetach", (Throwable)e);
                }
            } else {
                view.onFinishTemporaryDetach();
            }
        }

        private void bindTempDetach() {
            try {
                this.mDispatchStartTemporaryDetach = View.class.getDeclaredMethod("dispatchStartTemporaryDetach", new Class[0]);
                this.mDispatchFinishTemporaryDetach = View.class.getDeclaredMethod("dispatchFinishTemporaryDetach", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)ViewCompat.TAG, (String)"Couldn't find method", (Throwable)e);
            }
            this.mTempDetachBound = true;
        }

        @Override
        public float getTranslationX(View view) {
            return 0.0f;
        }

        @Override
        public float getTranslationY(View view) {
            return 0.0f;
        }

        @Override
        public float getX(View view) {
            return 0.0f;
        }

        @Override
        public float getY(View view) {
            return 0.0f;
        }

        @Override
        public float getRotation(View view) {
            return 0.0f;
        }

        @Override
        public float getRotationX(View view) {
            return 0.0f;
        }

        @Override
        public float getRotationY(View view) {
            return 0.0f;
        }

        @Override
        public float getScaleX(View view) {
            return 0.0f;
        }

        @Override
        public float getScaleY(View view) {
            return 0.0f;
        }

        @Override
        public int getMinimumWidth(View view) {
            return 0;
        }

        @Override
        public int getMinimumHeight(View view) {
            return 0;
        }

        @Override
        public ViewPropertyAnimatorCompat animate(View view) {
            return new ViewPropertyAnimatorCompat(view);
        }

        @Override
        public void setRotation(View view, float value) {
        }

        @Override
        public void setTranslationX(View view, float value) {
        }

        @Override
        public void setTranslationY(View view, float value) {
        }

        @Override
        public void setAlpha(View view, float value) {
        }

        @Override
        public void setRotationX(View view, float value) {
        }

        @Override
        public void setRotationY(View view, float value) {
        }

        @Override
        public void setScaleX(View view, float value) {
        }

        @Override
        public void setScaleY(View view, float value) {
        }

        @Override
        public void setX(View view, float value) {
        }

        @Override
        public void setY(View view, float value) {
        }

        @Override
        public void setPivotX(View view, float value) {
        }

        @Override
        public void setPivotY(View view, float value) {
        }

        @Override
        public float getPivotX(View view) {
            return 0.0f;
        }

        @Override
        public float getPivotY(View view) {
            return 0.0f;
        }
    }

    static interface ViewCompatImpl {
        public boolean canScrollHorizontally(View var1, int var2);

        public boolean canScrollVertically(View var1, int var2);

        public int getOverScrollMode(View var1);

        public void setOverScrollMode(View var1, int var2);

        public void onInitializeAccessibilityEvent(View var1, AccessibilityEvent var2);

        public void onPopulateAccessibilityEvent(View var1, AccessibilityEvent var2);

        public void onInitializeAccessibilityNodeInfo(View var1, AccessibilityNodeInfoCompat var2);

        public void setAccessibilityDelegate(View var1, AccessibilityDelegateCompat var2);

        public boolean hasTransientState(View var1);

        public void setHasTransientState(View var1, boolean var2);

        public void postInvalidateOnAnimation(View var1);

        public void postInvalidateOnAnimation(View var1, int var2, int var3, int var4, int var5);

        public void postOnAnimation(View var1, Runnable var2);

        public void postOnAnimationDelayed(View var1, Runnable var2, long var3);

        public int getImportantForAccessibility(View var1);

        public void setImportantForAccessibility(View var1, int var2);

        public boolean performAccessibilityAction(View var1, int var2, Bundle var3);

        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View var1);

        public float getAlpha(View var1);

        public void setLayerType(View var1, int var2, Paint var3);

        public int getLayerType(View var1);

        public int getLabelFor(View var1);

        public void setLabelFor(View var1, int var2);

        public void setLayerPaint(View var1, Paint var2);

        public int getLayoutDirection(View var1);

        public void setLayoutDirection(View var1, int var2);

        public ViewParent getParentForAccessibility(View var1);

        public boolean isOpaque(View var1);

        public int resolveSizeAndState(int var1, int var2, int var3);

        public int getMeasuredWidthAndState(View var1);

        public int getMeasuredHeightAndState(View var1);

        public int getMeasuredState(View var1);

        public int getAccessibilityLiveRegion(View var1);

        public void setAccessibilityLiveRegion(View var1, int var2);

        public int getPaddingStart(View var1);

        public int getPaddingEnd(View var1);

        public void setPaddingRelative(View var1, int var2, int var3, int var4, int var5);

        public void dispatchStartTemporaryDetach(View var1);

        public void dispatchFinishTemporaryDetach(View var1);

        public float getX(View var1);

        public float getY(View var1);

        public float getRotation(View var1);

        public float getRotationX(View var1);

        public float getRotationY(View var1);

        public float getScaleX(View var1);

        public float getScaleY(View var1);

        public float getTranslationX(View var1);

        public float getTranslationY(View var1);

        public int getMinimumWidth(View var1);

        public int getMinimumHeight(View var1);

        public ViewPropertyAnimatorCompat animate(View var1);

        public void setRotation(View var1, float var2);

        public void setRotationX(View var1, float var2);

        public void setRotationY(View var1, float var2);

        public void setScaleX(View var1, float var2);

        public void setScaleY(View var1, float var2);

        public void setTranslationX(View var1, float var2);

        public void setTranslationY(View var1, float var2);

        public void setX(View var1, float var2);

        public void setY(View var1, float var2);

        public void setAlpha(View var1, float var2);

        public void setPivotX(View var1, float var2);

        public void setPivotY(View var1, float var2);

        public float getPivotX(View var1);

        public float getPivotY(View var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    private static @interface ResolvedLayoutDirectionMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L})
    private static @interface LayoutDirectionMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    private static @interface LayerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    private static @interface AccessibilityLiveRegion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 4L})
    private static @interface ImportantForAccessibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 1L})
    private static @interface OverScroll {
    }
}

