/*
 * Decompiled with CFR 0.152.
 */
package initTag;

import com.uhf.api.cls.Reader;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InitTagWrite
extends JFrame {
    private JTextField port;
    private JComboBox<Integer> antcount;
    private JTextField accpwd;
    private JTextField killpwd;
    private JTextField selantenna;
    private JTextField epc;
    private JTextField writeData;
    private JTextField bank;
    private JTextField address;
    Reader rdr = null;

    public InitTagWrite(int h, int w) {
        Container coter = this.getContentPane();
        this.setLayout(null);
        JButton jbt1 = new JButton("Initialize Tags");
        jbt1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String acpwd = InitTagWrite.this.accpwd.getText();
                byte[] acpwdb = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(acpwd, acpwd.length(), acpwdb);
                String klpwd = InitTagWrite.this.killpwd.getText();
                byte[] klpwdb = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(klpwd, klpwd.length(), klpwdb);
                String sepc = InitTagWrite.this.epc.getText();
                byte[] wepc = new byte[sepc.length() / 2];
                InitTagWrite.this.rdr.Str2Hex(sepc, sepc.length(), wepc);
                Reader.READER_ERR err = InitTagWrite.this.rdr.WriteTagEpcEx(Integer.parseInt(InitTagWrite.this.selantenna.getText()), wepc, sepc.length() / 2, null, (short)1000);
                if (err != Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
                    return;
                }
                err = InitTagWrite.this.rdr.WriteTagData(Integer.parseInt(InitTagWrite.this.selantenna.getText()), '\u0000', 0, klpwdb, 4, null, (short)1000);
                if (err != Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
                    return;
                }
                err = InitTagWrite.this.rdr.WriteTagData(Integer.parseInt(InitTagWrite.this.selantenna.getText()), '\u0000', 2, acpwdb, 4, null, (short)1000);
                if (err != Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
                    return;
                }
                byte bt = (byte)(Reader.Lock_Obj.LOCK_OBJECT_KILL_PASSWORD.value() | Reader.Lock_Obj.LOCK_OBJECT_ACCESS_PASSWD.value() | Reader.Lock_Obj.LOCK_OBJECT_BANK1.value());
                short st = (short)(Reader.Lock_Type.KILL_PASSWORD_LOCK.value() | Reader.Lock_Type.ACCESS_PASSWD_LOCK.value() | Reader.Lock_Type.BANK1_LOCK.value());
                err = InitTagWrite.this.rdr.LockTag(Integer.parseInt(InitTagWrite.this.selantenna.getText()), bt, st, acpwdb, (short)1000);
                if (err != Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
                    return;
                }
                InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                InitTagWrite.this.MessageBox("Operation successful");
            }
        });
        JButton jbt2 = new JButton("Write EPC");
        jbt2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String pwd = InitTagWrite.this.accpwd.getText();
                byte[] pwdb = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(pwd, pwd.length(), pwdb);
                String sepc = InitTagWrite.this.epc.getText();
                byte[] wepc = new byte[sepc.length() / 2];
                InitTagWrite.this.rdr.Str2Hex(sepc, sepc.length(), wepc);
                Reader.READER_ERR err = InitTagWrite.this.rdr.WriteTagEpcEx(Integer.parseInt(InitTagWrite.this.selantenna.getText()), wepc, wepc.length, pwdb, (short)1000);
                if (err == Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                    InitTagWrite.this.MessageBox("Operation successful");
                    return;
                }
                InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
            }
        });
        JButton jbt3 = new JButton("Write memory");
        jbt3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String pwd = InitTagWrite.this.accpwd.getText();
                byte[] accesspwd = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(pwd, pwd.length(), accesspwd);
                String data = InitTagWrite.this.writeData.getText();
                byte[] wdata = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(data, data.length(), wdata);
                Reader.READER_ERR err = InitTagWrite.this.rdr.WriteTagData(Integer.parseInt(InitTagWrite.this.selantenna.getText()), (char)Integer.parseInt(InitTagWrite.this.bank.getText()), Integer.parseInt(InitTagWrite.this.address.getText()), wdata, 4, accesspwd, (short)1000);
                if (err == Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                    InitTagWrite.this.MessageBox("Operation successful");
                    return;
                }
                InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
            }
        });
        JButton jbt4 = new JButton("Read memory");
        jbt4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String pwd = InitTagWrite.this.accpwd.getText();
                byte[] accesspwd = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(pwd, pwd.length(), accesspwd);
                int len = 2;
                byte[] rdata = new byte[len * 2];
                Reader.READER_ERR err = InitTagWrite.this.rdr.GetTagData(Integer.parseInt(InitTagWrite.this.selantenna.getText()), (char)Integer.parseInt(InitTagWrite.this.bank.getText()), Integer.parseInt(InitTagWrite.this.address.getText()), len, rdata, accesspwd, (short)1000);
                if (err == Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                    InitTagWrite.this.MessageBox("Operation successful");
                    StringBuilder sb = new StringBuilder();
                    for (byte b : rdata) {
                        sb.append(String.format("%02x", b));
                    }
                    InitTagWrite.this.MessageBox(sb.toString());
                    return;
                }
                InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
            }
        });
        JButton jbt5 = new JButton("Lock Tag");
        jbt5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String pwd = InitTagWrite.this.accpwd.getText();
                byte[] accesspwd = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(pwd, pwd.length(), accesspwd);
                Reader.READER_ERR err = InitTagWrite.this.rdr.LockTag(Integer.parseInt(InitTagWrite.this.selantenna.getText()), (byte)Reader.Lock_Obj.LOCK_OBJECT_BANK1.value(), (short)((byte)Reader.Lock_Type.BANK1_LOCK.value()), accesspwd, (short)1000);
                if (err == Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                    InitTagWrite.this.MessageBox("Operation successful");
                    return;
                }
                InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
            }
        });
        JButton jbt6 = new JButton("Kill Tags");
        jbt6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InitTagWrite.this.PreTagOp()) {
                    return;
                }
                String pwd = InitTagWrite.this.killpwd.getText();
                byte[] killpwd = new byte[4];
                InitTagWrite.this.rdr.Str2Hex(pwd, pwd.length(), killpwd);
                Reader.READER_ERR err = InitTagWrite.this.rdr.KillTag(Integer.parseInt(InitTagWrite.this.selantenna.getText()), killpwd, (short)1000);
                if (err == Reader.READER_ERR.MT_OK_ERR) {
                    InitTagWrite.this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, null);
                    InitTagWrite.this.MessageBox("Operation successful");
                    return;
                }
                InitTagWrite.this.MessageBox("Operation failed, error code: " + err.toString());
            }
        });
        JButton btnConnect = new JButton("Connect");
        btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InitTagWrite.this.OpenReader();
            }
        });
        this.port = new JTextField("192.168.10.99", 20);
        JLabel portLabel = new JLabel("Port");
        portLabel.setLabelFor(this.port);
        Integer[] antCounts = new Integer[]{1, 2, 4, 8, 16};
        this.antcount = new JComboBox<Integer>(antCounts);
        JLabel countLabel = new JLabel("Number of possible antennas");
        countLabel.setLabelFor(this.antcount);
        this.accpwd = new JTextField("00000000");
        JLabel accLabel = new JLabel("Access password (hex)");
        accLabel.setLabelFor(this.accpwd);
        this.killpwd = new JTextField("00000000");
        JLabel killLabel = new JLabel("Kill password (hex)");
        killLabel.setLabelFor(this.killpwd);
        this.selantenna = new JTextField("1");
        JLabel selAntLabel = new JLabel("Operating antenna");
        selAntLabel.setLabelFor(this.selantenna);
        this.epc = new JTextField("012345678901234567890129");
        JLabel epcLabel = new JLabel("EPC (hex)");
        epcLabel.setLabelFor(this.epc);
        this.bank = new JTextField("1");
        JLabel bankLabel = new JLabel("Bank to be written/read");
        bankLabel.setLabelFor(this.bank);
        this.writeData = new JTextField("");
        JLabel dataLabel = new JLabel("Data to be written (4 Byte)");
        dataLabel.setLabelFor(this.writeData);
        this.address = new JTextField("2");
        JLabel addrLabel = new JLabel("Data address to be written/read");
        addrLabel.setLabelFor(this.address);
        int x = 50;
        int y = 60;
        int xw = 200;
        int yh = 50;
        btnConnect.setBounds(x, y, xw, yh);
        jbt1.setBounds(x, y * 2, xw, yh);
        jbt2.setBounds(x, y * 3, xw, yh);
        jbt3.setBounds(x, y * 4, xw, yh);
        jbt4.setBounds(x, y * 5, xw, yh);
        jbt5.setBounds(x, y * 6, xw, yh);
        jbt6.setBounds(x, y * 7, xw, yh);
        x = 300;
        y = 30;
        yh = 25;
        portLabel.setBounds(x, y, xw, yh);
        this.port.setBounds(x, y * 2, xw, yh);
        countLabel.setBounds(x, y * 3, xw, yh);
        this.antcount.setBounds(x, y * 4, xw, yh);
        selAntLabel.setBounds(x, y * 5, xw, yh);
        this.selantenna.setBounds(x, y * 6, xw, yh);
        accLabel.setBounds(x, y * 7, xw, yh);
        this.accpwd.setBounds(x, y * 8, xw, yh);
        killLabel.setBounds(x, y * 9, xw, yh);
        this.killpwd.setBounds(x, y * 10, xw, yh);
        epcLabel.setBounds(x, y * 11, xw, yh);
        this.epc.setBounds(x, y * 12, xw, yh);
        bankLabel.setBounds(x, y * 13, xw, yh);
        this.bank.setBounds(x, y * 14, xw, yh);
        addrLabel.setBounds(x, y * 15, xw, yh);
        this.address.setBounds(x, y * 16, xw, yh);
        dataLabel.setBounds(x, y * 17, xw, yh);
        this.writeData.setBounds(x, y * 18, xw, yh);
        coter.add(btnConnect);
        coter.add(jbt1);
        coter.add(jbt2);
        coter.add(jbt3);
        coter.add(jbt4);
        coter.add(jbt5);
        coter.add(jbt6);
        coter.add(portLabel);
        coter.add(countLabel);
        coter.add(accLabel);
        coter.add(killLabel);
        coter.add(selAntLabel);
        coter.add(epcLabel);
        coter.add(bankLabel);
        coter.add(dataLabel);
        coter.add(addrLabel);
        coter.add(this.port);
        coter.add(this.antcount);
        coter.add(this.selantenna);
        coter.add(this.accpwd);
        coter.add(this.killpwd);
        coter.add(this.epc);
        coter.add(this.bank);
        coter.add(this.writeData);
        coter.add(this.address);
        this.setSize(w, h);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        if (this.OpenReader() != Reader.READER_ERR.MT_OK_ERR) {
            this.MessageBox("Failed to initialize the reader/writer. Please check the device address and type and reopen it.");
            return;
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (InitTagWrite.this.rdr != null) {
                    InitTagWrite.this.rdr.CloseReader();
                }
                System.exit(0);
            }
        });
    }

    Reader.READER_ERR OpenReader() {
        this.rdr = new Reader();
        Reader.READER_ERR er = this.rdr.InitReader_Notype(this.port.getText(), ((Integer)this.antcount.getSelectedItem()).intValue());
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            return er;
        }
        Reader.AntPowerConf apcf = new Reader.AntPowerConf(this.rdr);
        apcf.antcnt = (Integer)this.antcount.getSelectedItem();
        for (int i = 0; i < apcf.antcnt; ++i) {
            Reader.AntPower jaap = new Reader.AntPower(this.rdr);
            jaap.antid = i + 1;
            jaap.readPower = (short)2400;
            jaap.writePower = (short)2700;
            apcf.Powers[i] = jaap;
        }
        this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_FREQUENCY_REGION, (Object)Reader.Region_Conf.RG_EU3);
        er = this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_RF_ANTPOWER, (Object)apcf);
        if (er != Reader.READER_ERR.MT_OK_ERR) {
            return er;
        }
        Reader.Inv_Potls_ST ipst = new Reader.Inv_Potls_ST(this.rdr);
        ipst.potlcnt = 1;
        ipst.potls = new Reader.Inv_Potl[1];
        for (int i = 0; i < ipst.potlcnt; ++i) {
            Reader.Inv_Potl ipl = new Reader.Inv_Potl(this.rdr);
            ipl.weight = 30;
            ipl.potl = Reader.SL_TagProtocol.SL_TAG_PROTOCOL_GEN2;
            ipst.potls[0] = ipl;
        }
        er = this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_INVPOTL, (Object)ipst);
        return er;
    }

    void MessageBox(String mes) {
        JOptionPane.showMessageDialog(null, mes, "Notification", 1);
    }

    boolean PreTagOp() {
        int[] tagcnt = new int[1];
        Reader.TAGINFO taginfo = new Reader.TAGINFO(this.rdr);
        Reader.READER_ERR err = this.rdr.TagInventory_Raw(new int[]{Integer.parseInt(this.selantenna.getText())}, 1, (short)300, tagcnt);
        if (err != Reader.READER_ERR.MT_OK_ERR) {
            this.MessageBox("Inventory failed, error code: " + err.toString());
            return false;
        }
        if (tagcnt[0] != 1) {
            this.MessageBox("Please ensure that there is only one tag in the antenna field: " + tagcnt[0]);
            return false;
        }
        err = this.rdr.GetNextTag(taginfo);
        if (err != Reader.READER_ERR.MT_OK_ERR) {
            this.MessageBox("Failed to obtain tag, error code: " + err.toString());
            return false;
        }
        Reader.TagFilter_ST tfst = new Reader.TagFilter_ST(this.rdr);
        tfst.bank = 1;
        tfst.fdata = taginfo.EpcId;
        tfst.flen = taginfo.Epclen * 8;
        tfst.isInvert = 0;
        tfst.startaddr = 32;
        err = this.rdr.ParamSet(Reader.Mtr_Param.MTR_PARAM_TAG_FILTER, (Object)tfst);
        return true;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.library.path"));
        String arch = System.getProperty("os.arch");
        String os = System.getProperty("os.name");
        System.out.println(arch);
        System.out.println(os);
        try {
            if (!System.getProperty("os.arch").contains("64")) {
                System.loadLibrary("ACE");
            }
            System.loadLibrary("PCOMM");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("inittagwrite sample for java");
        InitTagWrite fm = new InitTagWrite(640, 640);
    }
}

