// System.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "System.h"
#include "Share.h"
#include "RFID.h"
#include "RFIDReaderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HANDLE			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;

extern CXPStyleButtonST	m_btnUltraLight;
extern CXPStyleButtonST	m_btnTypeB;
extern CXPStyleButtonST	m_btnTypeA;
extern CXPStyleButtonST	m_btnType15693;
extern CXPStyleButtonST	m_btnCPU;

int mBaudreates[] = {9600, 19200, 38400, 57600, 115200};

/////////////////////////////////////////////////////////////////////////////
// CSystem dialog


CSystem::CSystem(CWnd* pParent /*=NULL*/)
	: CDialog(CSystem::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSystem)
	m_strBuzzCount = _T("18");
	m_strBuzzTime = _T("0A");
	m_strSerNum = _T("00 00 00 00 00 00 00 01");
	m_strLEDCount = _T("18");
	m_strLEDTime = _T("0A");
	m_strRetSysMsg = _T("");
	//}}AFX_DATA_INIT
}


void CSystem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSystem)
	DDX_Control(pDX, IDC_BUTTONSearchBaud, m_btnSearchBaudrate);
	DDX_Control(pDX, IDC_EDITSysMsg, m_ctlSysMsg);
	DDX_Control(pDX, IDC_BUTTONSysClear, m_btnSysClear);
	DDX_Control(pDX, IDC_COMBOSetBaud, m_ctlSetBaud);
	DDX_Control(pDX, IDC_COMBOSetAddr, m_ctlSetAddr);
	DDX_Control(pDX, IDC_COMBODevAddr, m_ctlDevAddr);
	DDX_Control(pDX, IDC_BUTTONSetSerNumber, m_btnSetSerNum);
	DDX_Control(pDX, IDC_BUTTONSetBaud, m_btnSetBaud);
	DDX_Control(pDX, IDC_BUTTONSetAddr, m_btnSetAddr);
	DDX_Control(pDX, IDC_BUTTONLED, m_btnLED);
	DDX_Control(pDX, IDC_BUTTONBuzzer, m_btnBuzzer);
	DDX_Control(pDX, IDC_BUTTONOpenCom, m_btnOpenCom);
	DDX_Control(pDX, IDC_BUTTONCloseCom, m_btnCloseCom);
	DDX_Control(pDX, IDC_COMBOCOM, m_ctlCOM);
	DDX_Control(pDX, IDC_COMBOBaud, m_ctlBaud);
	DDX_Text(pDX, IDC_EDITBuzzCount, m_strBuzzCount);
	DDV_MaxChars(pDX, m_strBuzzCount, 2);
	DDX_Text(pDX, IDC_EDITBuzzTime, m_strBuzzTime);
	DDV_MaxChars(pDX, m_strBuzzTime, 2);
	DDX_Text(pDX, IDC_EDITDevSerNum, m_strSerNum);
	DDV_MaxChars(pDX, m_strSerNum, 23);
	DDX_Text(pDX, IDC_EDITLEDCount, m_strLEDCount);
	DDV_MaxChars(pDX, m_strLEDCount, 2);
	DDX_Text(pDX, IDC_EDITLEDTime, m_strLEDTime);
	DDV_MaxChars(pDX, m_strLEDTime, 2);
	DDX_Text(pDX, IDC_EDITSysMsg, m_strRetSysMsg);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSystem, CDialog)
	//{{AFX_MSG_MAP(CSystem)
	ON_BN_CLICKED(IDC_BUTTONOpenCom, OnBUTTONOpenCom)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTONCloseCom, OnBUTTONCloseCom)
	ON_BN_CLICKED(IDC_BUTTONBuzzer, OnBUTTONBuzzer)
	ON_BN_CLICKED(IDC_BUTTONLED, OnButtonled)
	ON_BN_CLICKED(IDC_BUTTONSetAddr, OnBUTTONSetAddr)
	ON_BN_CLICKED(IDC_BUTTONSetBaud, OnBUTTONSetBaud)
	ON_BN_CLICKED(IDC_BUTTONSetSerNumber, OnBUTTONSetSerNumber)
	ON_EN_CHANGE(IDC_EDITDevSerNum, OnChangeEDITDevSerNum)
	ON_EN_CHANGE(IDC_EDITBuzzTime, OnChangeEDITBuzzTime)
	ON_EN_CHANGE(IDC_EDITBuzzCount, OnChangeEDITBuzzCount)
	ON_EN_CHANGE(IDC_EDITLEDTime, OnChangeEDITLEDTime)
	ON_EN_CHANGE(IDC_EDITLEDCount, OnChangeEDITLEDCount)
	ON_BN_CLICKED(IDC_BUTTONSysClear, OnBUTTONSysClear)
	ON_BN_CLICKED(IDC_BUTTONSearchBaud, OnBUTTONSearchBaud)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSystem message handlers

BOOL CSystem::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnSetSerNum.SetThemeHelper(&m_ThemeHelper);
	m_btnSetBaud.SetThemeHelper(&m_ThemeHelper);
	m_btnSetAddr.SetThemeHelper(&m_ThemeHelper);
	m_btnLED.SetThemeHelper(&m_ThemeHelper);
	m_btnBuzzer.SetThemeHelper(&m_ThemeHelper);
	m_btnOpenCom.SetThemeHelper(&m_ThemeHelper);
	m_btnCloseCom.SetThemeHelper(&m_ThemeHelper);
	m_btnSysClear.SetThemeHelper(&m_ThemeHelper);
	m_btnSearchBaudrate.SetThemeHelper(&m_ThemeHelper);
	
	m_btnCloseCom.EnableWindow(FALSE);
	m_btnUltraLight.EnableWindow(FALSE);
	m_btnTypeB.EnableWindow(FALSE);
	m_btnTypeA.EnableWindow(FALSE);
	m_btnType15693.EnableWindow(FALSE);
	m_btnCPU.EnableWindow(FALSE);

	pDlgMenu = GetParent()->GetParent()->GetMenu();
	pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_GRAYED);

	CString		String;

	if (API_GetSysComm(Buffer) == 0) {
		char	COMNumber[4];
		for (int i = 0; i < Buffer[0]; i++) {
			String = "COM";
			itoa(Buffer[i + 1], &COMNumber[0], 10);
			String += &COMNumber[0];
			m_ctlCOM.InsertString(i, String);
		}
	}
	m_ctlCOM.SetCurSel(Buffer[0] - 1);

	for (int i = 0; i <= 0xff; i++) {
		String.Format(__T("%02X"), i);
		m_ctlDevAddr.InsertString(i, String);
		m_ctlSetAddr.InsertString(i, String);
	}
	m_ctlDevAddr.SetCurSel(0);
	m_ctlSetAddr.SetCurSel(0);

	m_ctlBaud.InsertString(0, "9600");
	m_ctlBaud.InsertString(1, "19200");
	m_ctlBaud.InsertString(2, "38400");
	m_ctlBaud.InsertString(3, "57600");
	m_ctlBaud.InsertString(4, "115200");
	m_ctlBaud.SetCurSel(0);

	m_ctlSetBaud.InsertString(0, "9600");
	m_ctlSetBaud.InsertString(1, "19200");
	m_ctlSetBaud.InsertString(2, "38400");
	m_ctlSetBaud.InsertString(3, "57600");
	m_ctlSetBaud.InsertString(4, "115200");
	m_ctlSetBaud.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSystem::OnBUTTONOpenCom() 
{
	// TODO: Add your control notification handler code here
	int		CurCOM, mBaudrate;
	char	CharTmp[8];
	char	VersionNum[32];
	CString	String, string;

	UpdateData(true);
	if (g_hCOM == INVALID_HANDLE_VALUE) {
		GetDlgItemText(IDC_COMBOCOM, StrTmp);
		strcpy(CharTmp, StrTmp);
		CurCOM = strtol(CharTmp+3, NULL, 10);

		GetDlgItemText(IDC_COMBOBaud, StrTmp);
		mBaudrate = atoi(StrTmp);
	
		StrTmp.Format(">>Connect\r\n");
		if ( (g_hCOM = API_OpenComm(CurCOM, mBaudrate)) > 0) {
			GetDlgItemText(IDC_COMBODevAddr, string);
			DeviceAddr = (unsigned char)strtol(string, NULL, 16);
			
			if ( (API_GetSerNum(g_hCOM, DeviceAddr, Buffer) != 0) || (API_GetVersionNum(g_hCOM, DeviceAddr, VersionNum) != 0)) {
				API_CloseComm(g_hCOM);
				String.Format("<<Connect Fail!");
				StrTmp += String;
				CShare::WriteToResult(StrTmp, m_strRetSysMsg);
				g_hCOM = INVALID_HANDLE_VALUE;
				GetDlgItem(IDC_ProductNum)->SetWindowText("");
				GetDlgItem(IDC_HandVersion)->SetWindowText("");
			}
			else {
				String.Format("<<Connect Success!");
				StrTmp += String;
				CShare::WriteToResult(StrTmp, m_strRetSysMsg);

				m_btnCloseCom.EnableWindow(TRUE);
				m_btnOpenCom.EnableWindow(FALSE);
				m_btnUltraLight.EnableWindow(TRUE);
				m_btnTypeB.EnableWindow(TRUE);
				m_btnTypeA.EnableWindow(TRUE);
				m_btnType15693.EnableWindow(TRUE);
				m_btnCPU.EnableWindow(TRUE);

				pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_ENABLED);
				pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_ENABLED);
				pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_ENABLED);
				pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_ENABLED);
				pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_ENABLED);
				pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_ENABLED);
	
				string = "";
				for (int i = 0; i < 8; i++) {
					String.Format("%02X ", Buffer[i + 2]);
					string += String;
				}
				GetDlgItem(IDC_ProductNum)->SetWindowText(string);
				
				string.Format("%s", VersionNum);
				GetDlgItem(IDC_HandVersion)->SetWindowText(string);
			}
		}
		else {
			String.Format("<<Connect Fail!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);
			g_hCOM = INVALID_HANDLE_VALUE;
		}
	}

//	g_hCOM = NULL;
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

HBRUSH CSystem::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: Change any attributes of the DC here
	if (GetDlgItem(IDC_SoftVersion)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_HandVersion)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_ProductNum)->m_hWnd == pWnd->m_hWnd) {
		pDC->SetTextColor(RGB(0, 0, 255));
	}

	// TODO: Return a different brush if the default is not desired
	return hbr;
}

void CSystem::OnBUTTONCloseCom() 
{
	// TODO: Add your control notification handler code here
	CString	String;

	UpdateData(true);
	StrTmp.Format(">>Disconnect\r\n");
	if (g_hCOM != INVALID_HANDLE_VALUE) {
		if (API_CloseComm(g_hCOM) == 1) {
			g_hCOM = INVALID_HANDLE_VALUE;
			String.Format("<<Device has been disconnected!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);

			GetDlgItem(IDC_ProductNum)->SetWindowText("");
			GetDlgItem(IDC_HandVersion)->SetWindowText("");

			m_btnOpenCom.EnableWindow(TRUE);
			m_btnCloseCom.EnableWindow(FALSE);
			m_btnUltraLight.EnableWindow(FALSE);
			m_btnTypeB.EnableWindow(FALSE);
			m_btnTypeA.EnableWindow(FALSE);
			m_btnType15693.EnableWindow(FALSE);
			m_btnCPU.EnableWindow(FALSE);

			pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_GRAYED);
		}
		else {
			String.Format("<<Disconnect fail!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		}
	}

	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnBUTTONBuzzer() 
{
	// TODO: Add your control notification handler code here
	int		ret, BuzzerFreq, BuzzerDuration;
	CString	String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
		return;
	}

	StrTmp.Format(">>Execute Buzzer    "); 

	BuzzerFreq = strtol(m_strBuzzTime, NULL, 16);
	if (BuzzerFreq < 1 || BuzzerFreq > 50) {
		String.Format("\r\nError Input: Times > 0X00 !");	
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	BuzzerDuration = strtol(m_strBuzzCount, NULL, 16);
	if (BuzzerDuration < 1) {
		String.Format("\r\nError Input: 0X01 < Duration < 0X32 !");
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	String.Format("Times: %02X  Duration:%02X\r\n", BuzzerFreq, BuzzerDuration);
	StrTmp += String;

	memset(Buffer, 0, sizeof(Buffer));
	if ( (ret = API_ControlBuzzer(g_hCOM, DeviceAddr, BuzzerDuration, BuzzerFreq, Buffer)) != 0) {
		String.Format("<<Error Input: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Execute Buzzer success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnButtonled() 
{
	// TODO: Add your control notification handler code here
	int ret, LEDFreq, LEDDuration;
	CString String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
		return;
	}

	LEDFreq = strtol(m_strLEDTime, NULL, 16);
	if (LEDFreq < 1 || LEDFreq > 50) {
		StrTmp.Format("Error Input: LED times > 0X00 !");
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	LEDDuration = strtol(m_strLEDCount, NULL, 16);
	if (LEDDuration < 1) {
		StrTmp.Format("Error: LED 0X01 < Duration < 0X32 !");
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	StrTmp.Format(">>Execute LED    ");
	String.Format("Times: %02X  Duration:%02X\r\n", LEDFreq, LEDDuration);
	StrTmp += String;

	memset(Buffer, 0, sizeof(Buffer));
	if ( (ret = API_ControlLED(g_hCOM, DeviceAddr, LEDDuration, LEDFreq, Buffer)) != 0) {
		String.Format("<<Execute LED fail: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Execute LED success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnBUTTONSetAddr() 
{
	// TODO: Add your control notification handler code here
	int NewAddr, ret;
	CString String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
		return;
	}

	GetDlgItemText(IDC_COMBOSetAddr, StrTmp);
	NewAddr = strtol(StrTmp, NULL, 16);

	StrTmp.Format(">>Setting Address: %02X\r\n", NewAddr);
	if ( (ret = API_SetDeviceAddress(g_hCOM, DeviceAddr, NewAddr, Buffer)) != 0) {
		String.Format("<<Setting address error : %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Address: %02X", Buffer[0]);
		StrTmp += String;
		DeviceAddr = NewAddr;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnBUTTONSetBaud() 
{
	// TODO: Add your control notification handler code here
	int		NewBaud, ret;
	CString	String;
	CString String1;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
		return;
	}
	
	NewBaud = m_ctlSetBaud.GetCurSel();

	GetDlgItemText(IDC_COMBOSetBaud, String);
	StrTmp.Format(">>Setting Baudrate: %s\r\n", String);
	if ( (ret = API_SetBaudrate(g_hCOM, DeviceAddr, NewBaud, Buffer)) != 0) {
		String.Format("<<Setting Baudrate error: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		GetDlgItemText(IDC_COMBOSetBaud, String);
		String1.Format("<<Baudrate: %s", String);
		StrTmp += String1;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnBUTTONSetSerNumber() 
{
	// TODO: Add your control notification handler code here
	
	unsigned char	SerNum[32];
	int				ret;
	CString			String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
		return;
	}

	strcpy( (char *)SerNum, m_strSerNum);
	int SizeStr = CShare::OXStrtoD(SerNum);

	if (SizeStr != 8) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	GetDlgItemText(IDC_EDITDevSerNum, String);
	StrTmp.Format(">>Setting S/N: %s\r\n", String);
	if ( (ret = API_SetSerNum(g_hCOM, DeviceAddr, SerNum, Buffer)) != 0) {
		String.Format("<<Setting S/N error: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Setting S/N success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnChangeEDITDevSerNum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITDevSerNum);
	m_strSerNum = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnChangeEDITBuzzTime() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBuzzTime);
	m_strBuzzTime = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnChangeEDITBuzzCount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBuzzCount);
	m_strBuzzCount = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnChangeEDITLEDTime() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLEDTime);
	m_strLEDTime = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnChangeEDITLEDCount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLEDCount);
	m_strLEDCount = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlSysMsg.LineScroll(m_ctlSysMsg.GetLineCount() -1, 0);
}

void CSystem::OnBUTTONSysClear()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRetSysMsg = "";
	UpdateData(false);
}

void CSystem::OnBUTTONSearchBaud() 
{
	// TODO: Add your control notification handler code here
	int		CurCOM;
	char	CharTmp[8];

	GetDlgItemText(IDC_COMBOCOM, StrTmp);
	strcpy(CharTmp, StrTmp);
	CurCOM = strtol(CharTmp+3, NULL, 10);
	for (int i = 0; i < m_ctlBaud.GetCount(); i++) {
		HANDLE handle;
		if ( (handle = API_OpenComm(CurCOM, mBaudreates[i])) > 0) {
			if (API_GetSerNum(handle, DeviceAddr, Buffer) != 0) {
				API_CloseComm(handle);
				continue;
			} else {
				m_ctlBaud.SetCurSel(i);
				API_CloseComm(handle);
				break;
			}
		}	
	}
}
