// CPU.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "CPU.h"
#include "Share.h"
#include "RFID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HANDLE			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;

/////////////////////////////////////////////////////////////////////////////
// CCPU dialog


CCPU::CCPU(CWnd* pParent /*=NULL*/)
	: CDialog(CCPU::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCPU)
	m_strCPUATS = _T("");
	m_strCPUSendData = _T("00 84 00 00 08");
	m_strRetCPUMSG = _T("");
	//}}AFX_DATA_INIT
}


void CCPU::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCPU)
	DDX_Control(pDX, IDC_EDITRetCPUMSG, m_ctlRetCPUMSG);
	DDX_Control(pDX, IDC_BUTTONCPUClear, m_btnCPUClear);
	DDX_Control(pDX, IDC_BUTTONRestart, m_btnRestart);
	DDX_Control(pDX, IDC_BUTTONPowerUp, m_btnPowerUp);
	DDX_Control(pDX, IDC_BUTTON_APDU, m_btnAPDU);
	DDX_Text(pDX, IDC_EDITCPUATS, m_strCPUATS);
	DDX_Text(pDX, IDC_EDITCPUSendData, m_strCPUSendData);
	DDX_Text(pDX, IDC_EDITRetCPUMSG, m_strRetCPUMSG);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCPU, CDialog)
	//{{AFX_MSG_MAP(CCPU)
	ON_EN_CHANGE(IDC_EDITCPUSendData, OnChangeEDITCPUSendData)
	ON_EN_CHANGE(IDC_EDITCPUATS, OnChangeEditcpuats)
	ON_BN_CLICKED(IDC_BUTTONPowerUp, OnBUTTONPowerUp)
	ON_BN_CLICKED(IDC_BUTTONRestart, OnBUTTONRestart)
	ON_BN_CLICKED(IDC_BUTTON_APDU, OnButtonApdu)
	ON_BN_CLICKED(IDC_BUTTONCPUClear, OnBUTTONCPUClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCPU message handlers

BOOL CCPU::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnRestart.SetThemeHelper(&m_ThemeHelper);
	m_btnPowerUp.SetThemeHelper(&m_ThemeHelper);
	m_btnAPDU.SetThemeHelper(&m_ThemeHelper);
	m_btnCPUClear.SetThemeHelper(&m_ThemeHelper);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCPU::OnChangeEDITCPUSendData() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITCPUSendData);
	m_strCPUSendData = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
}

void CCPU::OnChangeEditcpuats() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	
}

void CCPU::OnBUTTONPowerUp() 
{
	// TODO: Add your control notification handler code here
	CString	String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRetCPUMSG);
		UpdateData(false);
		m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
		return;
	}
	
	StrTmp.Format(">>RATS\r\n");
	if ( (ret = API_MF_PowerOn(g_hCOM, DeviceAddr, 0x26, 0x00, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
		m_strCPUATS = "";
	}
	else {
		StrTmp += "<<";
		for (int i = 1; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
		m_strCPUATS = StrTmp;
		String.Format("RATS Success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetCPUMSG);
	UpdateData(false);
	m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
}

void CCPU::OnBUTTONRestart() 
{
	// TODO: Add your control notification handler code here
	CString String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRetCPUMSG);
		UpdateData(false);
		m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
		return;
	}
	
	StrTmp.Format(">>Reset Antenna\r\n");
	if ( (ret = API_MF_RST_Antenna(g_hCOM, DeviceAddr, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format(	"<<Reset Antenna Success!");
		String += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetCPUMSG);
	UpdateData(false);
	m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
}

void CCPU::OnButtonApdu() 
{
	// TODO: Add your control notification handler code here
	unsigned char	SendData[1024];
	unsigned char	DataLen;
	CString			String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device !", m_strRetCPUMSG);
		UpdateData(false);
		m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
		return;
	}

	strcpy( (char *)SendData, m_strCPUSendData);
	CShare::OXStrtoD(SendData);
	DataLen = strlen(m_strCPUSendData)/3 + ( (strlen(m_strCPUSendData)%3) ? 1 : 0);

	StrTmp.Format(">>APDU:%s\r\n", m_strCPUSendData);
	if ( (ret = API_MF_TransferCMD(g_hCOM, DeviceAddr, 0x00, DataLen, SendData, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format( "<<");
		StrTmp += String;
		for (int i = 3; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}

	CShare::WriteToResult(StrTmp, m_strRetCPUMSG);
	UpdateData(false);
	m_ctlRetCPUMSG.LineScroll(m_ctlRetCPUMSG.GetLineCount() -1, 0);
}

void CCPU::OnBUTTONCPUClear() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRetCPUMSG = "";
	UpdateData(false);
}
