// TypeB.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "TypeB.h"
#include "Share.h"
#include "RFID.h"
//#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern SOCKET			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;

/////////////////////////////////////////////////////////////////////////////
// CTypeB dialog


CTypeB::CTypeB(CWnd* pParent /*=NULL*/)
	: CDialog(CTypeB::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTypeB)
	m_strBSerNum = _T("");
	m_strBSendData = _T("00 00 07 00 A4 00 00 02 3F 00");
	m_strRetBMSG = _T("");
	m_strDataLen = _T("0A");
	//}}AFX_DATA_INIT
}


void CTypeB::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTypeB)
	DDX_Control(pDX, IDC_btn_TypeBClear, m_btn_TypeBClear);
	DDX_Control(pDX, IDC_btn_Transfer, m_btnTransfer);
	DDX_Control(pDX, IDC_btn_Rst, m_btnRst);
	DDX_Control(pDX, IDC_btn_Request, m_btnRequest);
	DDX_Control(pDX, IDC_btn_Attrib, m_btnAttrib);
	DDX_Control(pDX, IDC_btn_Anticoll, m_btnAnticoll);
	DDX_Text(pDX, IDC_EDITBSerNum, m_strBSerNum);
	DDV_MaxChars(pDX, m_strBSerNum, 11);
	DDX_Text(pDX, IDC_EDITBSendData, m_strBSendData);
	DDX_Text(pDX, IDC_EDITRetBMSG, m_strRetBMSG);
	DDX_Text(pDX, IDC_EDITBDataLen, m_strDataLen);
	DDV_MaxChars(pDX, m_strDataLen, 2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTypeB, CDialog)
	//{{AFX_MSG_MAP(CTypeB)
	ON_EN_CHANGE(IDC_EDITBSendData, OnChangeEDITBSendData)
	ON_EN_CHANGE(IDC_EDITBSerNum, OnChangeEDITBSerNum)
	ON_BN_CLICKED(IDC_btn_Request, OnbtnRequest)
	ON_BN_CLICKED(IDC_btn_Anticoll, OnbtnAnticoll)
	ON_BN_CLICKED(IDC_btn_Attrib, OnbtnAttrib)
	ON_BN_CLICKED(IDC_btn_Rst, OnbtnRst)
	ON_BN_CLICKED(IDC_btn_Transfer, OnbtnTransfer)
	ON_BN_CLICKED(IDC_btn_TypeBClear, OnbtnTypeBClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTypeB message handlers

BOOL CTypeB::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnTransfer.SetThemeHelper(&m_ThemeHelper);
	m_btnRst.SetThemeHelper(&m_ThemeHelper);
	m_btnRequest.SetThemeHelper(&m_ThemeHelper);
	m_btnAttrib.SetThemeHelper(&m_ThemeHelper);
	m_btnAnticoll.SetThemeHelper(&m_ThemeHelper);
	m_btn_TypeBClear.SetThemeHelper(&m_ThemeHelper);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTypeB::OnChangeEDITBSendData() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int	nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBSendData);
	m_strBSendData = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);

	CString	String;
	String.Format("%02X", strlen(m_strBSendData)/3 + ((strlen(m_strBSendData)%3) ? 1 : 0));
	SetDlgItemText(IDC_EDITBDataLen, String);
}

void CTypeB::OnChangeEDITBSerNum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int	nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBSerNum);
	m_strBSerNum = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CTypeB::OnbtnRequest() 
{
	// TODO: Add your control notification handler code here
	CString String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetBMSG);
		UpdateData(false);
		return;
	}
	
	StrTmp.Format(">>Search Card\r\n");
	if ( (ret = API_Request_B(g_hCOM, DeviceAddr, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Search Card Success!\n");
		StrTmp += String;
		//if (Buffer[0] == 0x04 && Buffer[1] == 0x00)
		//	String.Format(": %s", "M1");
		//StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetBMSG);
	UpdateData(false);
}

void CTypeB::OnbtnAnticoll() 
{
	// TODO: Add your control notification handler code here
	CString		String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetBMSG);
		UpdateData(false);
		return;
	}

	StrTmp.Format(">>Anti-collision\r\n");
	if ( (ret = API_Anticoll_B(g_hCOM, DeviceAddr, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Card ID: ");
		StrTmp += String;
		for (int i = 1; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}

	CShare::WriteToResult(StrTmp, m_strRetBMSG);
	UpdateData(false);
}

void CTypeB::OnbtnAttrib() 
{
	// TODO: Add your control notification handler code here
	unsigned char	SerialNum[16];
	CString			String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetBMSG);
		UpdateData(false);
		return;
	}
	
	strcpy( (char *)SerialNum, m_strBSerNum);
	CShare::OXStrtoD(SerialNum);

	StrTmp.Format(">>Attrib\r\n");
	if ( (ret = API_Attrib_B(g_hCOM, DeviceAddr, SerialNum, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Command Operate Success!\n");
		StrTmp += String;
	}
	
	CShare::WriteToResult(StrTmp, m_strRetBMSG);
	UpdateData(false);
}

void CTypeB::OnbtnRst() 
{
	// TODO: Add your control notification handler code here
	CString String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetBMSG);
		UpdateData(false);
		return;
	}

	StrTmp.Format(">>Reset\r\n");
	if ( (ret = API_RESET_B(g_hCOM, DeviceAddr, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Command Operate Success!\n");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetBMSG);
	UpdateData(false);
}

void CTypeB::OnbtnTransfer() 
{
	// TODO: Add your control notification handler code here
	unsigned char	DataLen, TransferData[1024];
	CString			String;
	
	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetBMSG);
		UpdateData(false);
		return;
	}

	DataLen = (unsigned char) strtol(m_strDataLen, NULL, 16);
	strcpy((char *)TransferData, m_strBSendData);
	int SizeStr = CShare::OXStrtoD(TransferData);

	if (SizeStr != DataLen) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	StrTmp.Format(">>Transfer DataLenght:%s\r\n", m_strDataLen);
	if ( (ret = API_TransferCMD_B(g_hCOM, DeviceAddr, DataLen, TransferData, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Command Operate Success!\n");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetBMSG);
	UpdateData(false);	
}

void CTypeB::OnbtnTypeBClear() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRetBMSG = "";
	UpdateData(false);
}
