// System.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "System.h"
#include "Share.h"
#include "RFID.h"
#include "RFIDReaderDlg.h"
#include "ModifyIP.h"

#pragma comment(lib, "Setting.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern SOCKET			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;

extern CXPStyleButtonST	m_btnUltraLight;
extern CXPStyleButtonST	m_btnTypeB;
extern CXPStyleButtonST	m_btnTypeA;
extern CXPStyleButtonST	m_btnType15693;
extern CXPStyleButtonST	m_btnCPU;

int						m_nDevie;
DEVICEINFO				m_DeviceInfo[32];
C2000NETSETTING			pNS[32];
C2000SOCKETSETTING		pSS[32];
C2000COMSETTING			pCS[32];

CModifyIP				dlg;
extern C2000NETSETTING	NS;
extern C2000SOCKETSETTING SS;
extern C2000COMSETTING	CS;

/////////////////////////////////////////////////////////////////////////////
// CSystem dialog


CSystem::CSystem(CWnd* pParent /*=NULL*/)
	: CDialog(CSystem::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSystem)
	m_strBuzzCount = _T("18");
	m_strBuzzTime = _T("0A");
	m_strSerNum = _T("00 00 00 00 00 00 00 01");
	m_strLEDCount = _T("18");
	m_strLEDTime = _T("0A");
	m_strRetSysMsg = _T("");
	m_strIP = _T("");
	//}}AFX_DATA_INIT
}


void CSystem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSystem)
	DDX_Control(pDX, IDC_BUTTON_Relay, m_btnRelay);
	DDX_Control(pDX, IDC_COMBO_Relay, m_ctlRelay);
	DDX_Control(pDX, IDC_COMBOPort, m_ctlPort);
	DDX_Control(pDX, IDC_COMBOIP, m_ctlIP);
	DDX_Control(pDX, IDC_BUTTONIPModify, m_btnIPModify);
	DDX_Control(pDX, IDC_BUTTONSysClear, m_btnSysClear);
	DDX_Control(pDX, IDC_COMBOSetBaud, m_ctlSetBaud);
	DDX_Control(pDX, IDC_COMBOSetAddr, m_ctlSetAddr);
	DDX_Control(pDX, IDC_COMBODevAddr, m_ctlDevAddr);
	DDX_Control(pDX, IDC_BUTTONSetSerNumber, m_btnSetSerNum);
	DDX_Control(pDX, IDC_BUTTONSetBaud, m_btnSetBaud);
	DDX_Control(pDX, IDC_BUTTONSetAddr, m_btnSetAddr);
	DDX_Control(pDX, IDC_BUTTONLED, m_btnLED);
	DDX_Control(pDX, IDC_BUTTONBuzzer, m_btnBuzzer);
	DDX_Control(pDX, IDC_BUTTONOpenCom, m_btnOpenCom);
	DDX_Control(pDX, IDC_BUTTONCloseCom, m_btnCloseCom);
	DDX_Control(pDX, IDC_BUTTONSearch, m_btnSearch);
	DDX_Text(pDX, IDC_EDITBuzzCount, m_strBuzzCount);
	DDV_MaxChars(pDX, m_strBuzzCount, 2);
	DDX_Text(pDX, IDC_EDITBuzzTime, m_strBuzzTime);
	DDV_MaxChars(pDX, m_strBuzzTime, 2);
	DDX_Text(pDX, IDC_EDITDevSerNum, m_strSerNum);
	DDV_MaxChars(pDX, m_strSerNum, 23);
	DDX_Text(pDX, IDC_EDITLEDCount, m_strLEDCount);
	DDV_MaxChars(pDX, m_strLEDCount, 2);
	DDX_Text(pDX, IDC_EDITLEDTime, m_strLEDTime);
	DDV_MaxChars(pDX, m_strLEDTime, 2);
	DDX_Text(pDX, IDC_EDITSysMsg, m_strRetSysMsg);
	DDX_CBString(pDX, IDC_COMBOIP, m_strIP);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSystem, CDialog)
	//{{AFX_MSG_MAP(CSystem)
	ON_BN_CLICKED(IDC_BUTTONOpenCom, OnBUTTONOpenCom)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTONCloseCom, OnBUTTONCloseCom)
	ON_BN_CLICKED(IDC_BUTTONBuzzer, OnBUTTONBuzzer)
	ON_BN_CLICKED(IDC_BUTTONLED, OnButtonled)
	ON_BN_CLICKED(IDC_BUTTONSetAddr, OnBUTTONSetAddr)
	ON_BN_CLICKED(IDC_BUTTONSetBaud, OnBUTTONSetBaud)
	ON_BN_CLICKED(IDC_BUTTONSetSerNumber, OnBUTTONSetSerNumber)
	ON_EN_CHANGE(IDC_EDITDevSerNum, OnChangeEDITDevSerNum)
	ON_EN_CHANGE(IDC_EDITBuzzTime, OnChangeEDITBuzzTime)
	ON_EN_CHANGE(IDC_EDITBuzzCount, OnChangeEDITBuzzCount)
	ON_EN_CHANGE(IDC_EDITLEDTime, OnChangeEDITLEDTime)
	ON_EN_CHANGE(IDC_EDITLEDCount, OnChangeEDITLEDCount)
	ON_BN_CLICKED(IDC_BUTTONSysClear, OnBUTTONSysClear)
	ON_BN_CLICKED(IDC_BUTTONSearch, OnBUTTONSearch)
	ON_BN_CLICKED(IDC_BUTTONIPModify, OnBUTTONIPModify)
	ON_CBN_EDITCHANGE(IDC_COMBOIP, OnEditchangeComboip)
	ON_BN_CLICKED(IDC_BUTTON_Relay, OnBUTTONRelay)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSystem message handlers

BOOL CSystem::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnSetSerNum.SetThemeHelper(&m_ThemeHelper);
	m_btnSetBaud.SetThemeHelper(&m_ThemeHelper);
	m_btnSetAddr.SetThemeHelper(&m_ThemeHelper);
	m_btnLED.SetThemeHelper(&m_ThemeHelper);
	m_btnBuzzer.SetThemeHelper(&m_ThemeHelper);
	m_btnOpenCom.SetThemeHelper(&m_ThemeHelper);
	m_btnCloseCom.SetThemeHelper(&m_ThemeHelper);
	m_btnSysClear.SetThemeHelper(&m_ThemeHelper);
	m_btnSearch.SetThemeHelper(&m_ThemeHelper);
	m_btnIPModify.SetThemeHelper(&m_ThemeHelper);
	m_btnRelay.SetThemeHelper(&m_ThemeHelper);

	m_btnCloseCom.EnableWindow(FALSE);
	m_btnUltraLight.EnableWindow(FALSE);
	m_btnTypeB.EnableWindow(FALSE);
	m_btnTypeA.EnableWindow(FALSE);
	m_btnType15693.EnableWindow(FALSE);
	m_btnCPU.EnableWindow(FALSE);
	//m_btnIPModify.EnableWindow(FALSE);

	pDlgMenu = GetParent()->GetParent()->GetMenu();
	pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_GRAYED);
	pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_GRAYED);

	CString		String;
	/*String = "192.168.1.230";
	m_ctlCOM.InsertString(0, String);
	m_ctlCOM.SetCurSel(0);
	*/

	//String = "8000";
	//m_crlPort.InsertString(0, String);
	//m_crlPort.SetCurSel(0);

	for (int i = 0; i <= 0xff; i++) {
		String.Format(__T("%02X"), i);
		m_ctlDevAddr.InsertString(i, String);
		m_ctlSetAddr.InsertString(i, String);
	}
	m_ctlDevAddr.SetCurSel(0);
	m_ctlSetAddr.SetCurSel(0);

	m_ctlRelay.InsertString(0, "ON");
	m_ctlRelay.InsertString(1, "OFF");
	m_ctlRelay.SetCurSel(0);

	/*m_ctlBaud.InsertString(0, "9600");
	m_ctlBaud.InsertString(1, "19200");
	m_ctlBaud.InsertString(2, "38400");
	m_ctlBaud.InsertString(3, "57600");
	m_ctlBaud.InsertString(4, "115200");
	m_ctlBaud.SetCurSel(0);

	m_ctlSetBaud.InsertString(0, "9600");
	m_ctlSetBaud.InsertString(1, "19200");
	m_ctlSetBaud.InsertString(2, "38400");
	m_ctlSetBaud.InsertString(3, "57600");
	m_ctlSetBaud.InsertString(4, "115200");
	m_ctlSetBaud.SetCurSel(0);
	*/

	CreateSocket(IPPROTO_UDP, INADDR_BROADCAST, 21678, 0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSystem::OnBUTTONOpenCom() 
{
	// TODO: Add your control notification handler code here
	unsigned int	mPort;
	unsigned char	ip[4];
	//char			CharTmp[8];
	char			VersionNum[32];
	CString			String, string;

	UpdateData(true);
	StrTmp.Format(">>Connect\r\n");
	if (GetIPAddress(ip) != 0) {
		String.Format("<<Connect Fail: Please input the correct IP!");
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	GetDlgItemText(IDC_COMBOPort, string);
	mPort = atoi(string);
	//String.Format("%d.%d.%d.%d: %d", ip[0], ip[1], ip[2], ip[3], mPort);
	//MessageBox(String, "Attention", MB_OKCANCEL | MB_ICONINFORMATION);

	if ( (g_hCOM = API_OpenClientSocket(ip, mPort)) != INVALID_SOCKET) {
		GetDlgItemText(IDC_COMBODevAddr, string);
		DeviceAddr = (unsigned char)strtol(string, NULL, 16);
		
		if ( (API_GetSerNum(g_hCOM, DeviceAddr, Buffer) != 0) || (API_GetVersionNum(g_hCOM, DeviceAddr, VersionNum) != 0)) {
			API_CloseSocket(g_hCOM);
			String.Format("<<Connect Fail!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);
			g_hCOM = INVALID_SOCKET;
			GetDlgItem(IDC_ProductNum)->SetWindowText("");
			GetDlgItem(IDC_HandVersion)->SetWindowText("");
		}
		else {
			String.Format("<<Connect Success!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);

			m_btnCloseCom.EnableWindow(TRUE);
			m_btnOpenCom.EnableWindow(FALSE);
			m_btnUltraLight.EnableWindow(TRUE);
			m_btnTypeB.EnableWindow(TRUE);
			m_btnTypeA.EnableWindow(TRUE);
			m_btnType15693.EnableWindow(TRUE);
			m_btnCPU.EnableWindow(TRUE);

			pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_ENABLED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_ENABLED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_ENABLED);
			pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_ENABLED);
			pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_ENABLED);
			pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_ENABLED);

			string = "";
			for (int i = 0; i < 8; i++) {
				String.Format("%02X ", Buffer[i + 2]);
				string += String;
			}
			GetDlgItem(IDC_ProductNum)->SetWindowText(string);
			
			string.Format("%s", VersionNum);
			GetDlgItem(IDC_HandVersion)->SetWindowText(string);
		}
	}
	else {
		String.Format("<<Connect Fail!");
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		g_hCOM = INVALID_SOCKET;
	}

	UpdateData(false);
}

HBRUSH CSystem::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: Change any attributes of the DC here
	if (GetDlgItem(IDC_SoftVersion)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_HandVersion)->m_hWnd == pWnd->m_hWnd
		|| GetDlgItem(IDC_ProductNum)->m_hWnd == pWnd->m_hWnd) {
		pDC->SetTextColor(RGB(0, 0, 255));
	}

	// TODO: Return a different brush if the default is not desired
	return hbr;
}

void CSystem::OnBUTTONCloseCom() 
{
	// TODO: Add your control notification handler code here
	CString	String;

	UpdateData(true);
	StrTmp.Format(">>Disconnect\r\n");
	if (g_hCOM != INVALID_SOCKET) {
		if (API_CloseSocket(g_hCOM) == 0) {
			g_hCOM = INVALID_SOCKET;
			String.Format("<<Device has been disconnected!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);

			GetDlgItem(IDC_ProductNum)->SetWindowText("");
			GetDlgItem(IDC_HandVersion)->SetWindowText("");

			m_btnOpenCom.EnableWindow(TRUE);
			m_btnCloseCom.EnableWindow(FALSE);
			m_btnUltraLight.EnableWindow(FALSE);
			m_btnTypeB.EnableWindow(FALSE);
			m_btnTypeA.EnableWindow(FALSE);
			m_btnType15693.EnableWindow(FALSE);
			m_btnCPU.EnableWindow(FALSE);

			pDlgMenu->EnableMenuItem(ID_MENUSysCommand, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeA, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUTypeB, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUType15693, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUCPU, MF_GRAYED);
			pDlgMenu->EnableMenuItem(ID_MENUUltraLight, MF_GRAYED);
		}
		else {
			String.Format("<<Disconnect fail!");
			StrTmp += String;
			CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		}
	}
	UpdateData(false);
}

void CSystem::OnBUTTONBuzzer() 
{
	// TODO: Add your control notification handler code here
	int		ret, BuzzerFreq, BuzzerDuration;
	CString	String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	StrTmp.Format(">>Execute Buzzer    "); 

	BuzzerFreq = strtol(m_strBuzzTime, NULL, 16);
	if (BuzzerFreq < 1 || BuzzerFreq > 50) {
		String.Format("\r\nError Input: Times > 0X00 !");	
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	BuzzerDuration = strtol(m_strBuzzCount, NULL, 16);
	if (BuzzerDuration < 1) {
		String.Format("\r\nError Input: 0X01 < Duration < 0X32 !");
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	String.Format("Times: %02X  Duration:%02X\r\n", BuzzerFreq, BuzzerDuration);
	StrTmp += String;

	memset(Buffer, 0, sizeof(Buffer));
	if ( (ret = API_ControlBuzzer(g_hCOM, DeviceAddr, BuzzerDuration, BuzzerFreq, Buffer)) != 0) {
		String.Format("<<Error Input: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Execute Buzzer success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	UpdateData(false);
}

void CSystem::OnButtonled() 
{
	// TODO: Add your control notification handler code here
	int ret, LEDFreq, LEDDuration;
	CString String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	LEDFreq = strtol(m_strLEDTime, NULL, 16);
	if (LEDFreq < 1 || LEDFreq > 50) {
		StrTmp.Format("Error Input: LED times > 0X00 !");
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	LEDDuration = strtol(m_strLEDCount, NULL, 16);
	if (LEDDuration < 1) {
		StrTmp.Format("Error: LED 0X01 < Duration < 0X32 !");
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	StrTmp.Format(">>Execute LED    ");
	String.Format("Times: %02X  Duration:%02X\r\n", LEDFreq, LEDDuration);
	StrTmp += String;

	memset(Buffer, 0, sizeof(Buffer));
	if ( (ret = API_ControlLED(g_hCOM, DeviceAddr, LEDDuration, LEDFreq, Buffer)) != 0) {
		String.Format("<<Execute LED fail: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Execute LED success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
}

void CSystem::OnBUTTONSetAddr() 
{
	// TODO: Add your control notification handler code here
	int NewAddr, ret;
	CString String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	GetDlgItemText(IDC_COMBOSetAddr, StrTmp);
	NewAddr = strtol(StrTmp, NULL, 16);

	StrTmp.Format(">>Setting Address: %02X\r\n", NewAddr);
	if ( (ret = API_SetDeviceAddress(g_hCOM, DeviceAddr, NewAddr, Buffer)) != 0) {
		String.Format("<<Setting address error : %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Address: %02X", Buffer[0]);
		StrTmp += String;
		DeviceAddr = NewAddr;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	UpdateData(false);
}

void CSystem::OnBUTTONSetBaud() 
{
	// TODO: Add your control notification handler code here
	int		NewBaud, ret;
	CString	String;
	CString String1;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	NewBaud = m_ctlSetBaud.GetCurSel();

	GetDlgItemText(IDC_COMBOSetBaud, String);
	StrTmp.Format(">>Setting Baudrate: %s\r\n", String);
	if ( (ret = API_SetBaudrate(g_hCOM, DeviceAddr, NewBaud, Buffer)) != 0) {
		String.Format("<<Setting Baudrate error: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		GetDlgItemText(IDC_COMBOSetBaud, String);
		String1.Format("<<Baudrate: %s", String);
		StrTmp += String1;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
}

void CSystem::OnBUTTONSetSerNumber() 
{
	// TODO: Add your control notification handler code here
	
	unsigned char	SerNum[32];
	int				ret;
	CString			String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}

	strcpy( (char *)SerNum, m_strSerNum);
	int SizeStr = CShare::OXStrtoD(SerNum);

	if (SizeStr != 8) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	GetDlgItemText(IDC_EDITDevSerNum, String);
	StrTmp.Format(">>Setting S/N: %s\r\n", String);
	if ( (ret = API_SetSerNum(g_hCOM, DeviceAddr, SerNum, Buffer)) != 0) {
		String.Format("<<Setting S/N error: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	}
	else {
		String.Format("<<Setting S/N success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg); 
	UpdateData(false);
}

void CSystem::OnChangeEDITDevSerNum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITDevSerNum);
	m_strSerNum = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CSystem::OnChangeEDITBuzzTime() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBuzzTime);
	m_strBuzzTime = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CSystem::OnChangeEDITBuzzCount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITBuzzCount);
	m_strBuzzCount = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CSystem::OnChangeEDITLEDTime() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLEDTime);
	m_strLEDTime = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CSystem::OnChangeEDITLEDCount() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	int   nStart, nEnd;

	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITLEDCount);
	m_strLEDCount = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
}

void CSystem::OnBUTTONSysClear()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRetSysMsg = "";
	UpdateData(false);
}

int CSystem::GetIPAddress(unsigned char *ip)
{
	int		i, j = 0;
	CString strTmp = "", strIP = "";

	GetDlgItem(IDC_COMBOIP)->GetWindowText(strIP);
	if ("" == strIP) {
		return -1;
	}
	for (i = 0; i < strIP.GetLength(); i++) {
		if (strIP[i] != '.') {
			strTmp += strIP[i];
		}
		else {
			ip[j++] = atoi(strTmp);
			strTmp = "";
		}
	}

	ip[j++] = atoi(strTmp);
	if (j != 4) {
		return -1;
	}
	return 0;
}

void CSystem::OnBUTTONSearch()
{
	// TODO: Add your control notification handler code here
	m_ctlIP.ResetContent();
	m_ctlPort.ResetContent();
	UpdateData(true);

	int nNetCount = 1;
	int nSocketCount = 1;
	int nComCount = 1;
	CString String;

	//if (g_hCOM != INVALID_SOCKET) {
	//	OnBUTTONCloseCom();
	//}

	m_nDevie = SearchDevice(m_DeviceInfo, 32, 1000);
	CString strInfo;
	if (m_nDevie > 0) {
		int i;
		for (i = 0; i < m_nDevie; i++) {
			GetC2000Setting(m_DeviceInfo[i].strMAC, &pNS[i], &nNetCount, &pSS[i], &nSocketCount, &pCS[i], &nComCount, 1000);
			m_ctlIP.InsertString(0, m_DeviceInfo[i].strIP);
			String.Format("%d", pSS[i].nLocalPort);
			m_ctlPort.InsertString(0, String);
		}
		m_ctlIP.SetCurSel(0);
		m_ctlPort.SetCurSel(0);
		UpdateData(true);
	}

	//String.Format("%d", SS.nLocalPort);
	//MessageBox(String, "Attention", MB_OKCANCEL | MB_ICONINFORMATION);

	UpdateData(false);
}

void CSystem::OnBUTTONIPModify() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CString Tmp;
	CString String;
	int index;

	//if (INVALID_SOCKET == g_hCOM) {
	//	CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
	//	UpdateData(false);
	//	return;
	//}

	//StrTmp += String;
	if (m_ctlIP.GetCount() == 0) {
	//if (m_strIP == _T("")) {
		CShare::WriteToResult("Please Search Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	m_ctlIP.GetWindowText(Tmp);
	dlg.m_strMac = m_DeviceInfo[m_ctlIP.GetCurSel()].strMAC;
	dlg.m_strNewIP = Tmp;

	index = m_ctlIP.GetCurSel();
	NS = pNS[index];
	SS = pSS[index];
	CS = pCS[index];
	String.Format("%d", SS.nLocalPort);
	dlg.m_charPort = String;


	if (IDOK == dlg.DoModal()) {
		StrTmp.Format("<<Set IP Address\r\n");
		String.Format("<<Set IP Succeed!");
		StrTmp += String;
		CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	}

	UpdateData(false);
}

void CSystem::OnEditchangeComboip() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_ctlPort.SetCurSel(m_ctlIP.GetCurSel());
	UpdateData(false);
}

void CSystem::OnBUTTONRelay() 
{
	int		ret, relayFlag;
	CString	String;

	UpdateData(true);
	if (INVALID_SOCKET == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetSysMsg);
		UpdateData(false);
		return;
	}
	
	StrTmp.Format(">>Execute Relay: ");
	relayFlag = !m_ctlRelay.GetCurSel();
	String.Format("%s\r\n", relayFlag == 0 ? "OFF" : "ON");
	StrTmp += String;
	
	memset(Buffer, 0, sizeof(Buffer));
	if ( (ret = API_ControlRelay(g_hCOM, DeviceAddr, relayFlag, Buffer)) != 0) {
		String.Format("<<Error Input: %s!", CShare::Api_Error(ret));
		StrTmp += String;
	} else {
		String.Format("<<Execute Relay success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetSysMsg);
	UpdateData(false);
}
