// RFID.h : main header file for the RFID DLL
//

//#include <winsock2.h>
#include "Setting_Export.h"

#define RFID_EXPORTS

#ifdef	RFID_EXPORTS
#define RFID_API __declspec(dllexport) __stdcall
#else
#define RFID_API __declspec(dllimport) __stdcall
#endif


// System Command Function
extern "C" SOCKET	RFID_API API_OpenClientSocket(unsigned char *ip, unsigned int port);

extern "C" SOCKET	RFID_API API_OpenServerSocket(unsigned int port);

extern "C" SOCKET	RFID_API API_OpenUDPServerSocket(unsigned int port);

extern "C" int		RFID_API API_CloseSocket(SOCKET s);

extern "C" int		RFID_API API_SetDeviceAddress(SOCKET commHandle, int DeviceAddress, unsigned char NewAddress, unsigned char *Buffer);

extern "C" int		RFID_API API_SetBaudrate(SOCKET commHandle, int DeviceAddress, unsigned char NewBaud, unsigned char *Buffer);

extern "C" int		RFID_API API_SetSerNum(SOCKET commHandle, int DeviceAddress, unsigned char *NewValue, unsigned char *Buffer);

extern "C" int		RFID_API API_GetSerNum(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer);

//extern "C" int	RFID_API API_WriteUserInfo(SOCKET commHandle, int DeviceAddress, int NumBlockk, int NumLength, char *UserInfo);

//extern "C" int	RFID_API API_ReadUserInfo(SOCKET commHandle, int DeviceAddress, int NumBlock, int NumLength, char *UserInfo);

extern "C" int		RFID_API API_GetVersionNum(SOCKET commHandle, int DeviceAddress, char *VersionNum);

extern "C" int		RFID_API API_ControlLED(SOCKET commHandle, int DeviceAddress, unsigned char Freq, unsigned char Duration, unsigned char *Buffer);

extern "C" int		RFID_API API_ControlBuzzer(SOCKET commHandle, int DeviceAddress, unsigned char Freq, unsigned char Duration, unsigned char *Buffer);

extern "C" int		RFID_API API_ControlRelay(SOCKET commHandle, int DeviceAddress, unsigned char flag, unsigned char *Buffer);

// ISO14443 TypeA Function
extern "C" int RFID_API API_MF_Request(SOCKET commHandle, int DeviceAddress, unsigned char inf_mode, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Anticoll(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Select(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char UIDLen, unsigned char *uid, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Halt(SOCKET commHandle, int DeviceAddress);


// ISO14443 TypeB Function
extern "C" int RFID_API API_Request_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer);

extern "C" int RFID_API API_Anticoll_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer);

extern "C" int RFID_API API_Attrib_B(SOCKET commHandle, int DeviceAddress, unsigned char *SerialNum, unsigned char *Buffer);

extern "C" int RFID_API API_RESET_B(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer);

extern "C" int RFID_API API_TransferCMD_B(SOCKET commHandle, int DeviceAddress, unsigned char cmdSize, unsigned char *cmd, unsigned char *Buffer);


// ISO15693 Function
extern "C" int RFID_API API_ISO15693_Inventory(	SOCKET commHandle, int deviceAddress, unsigned char flag, 
												unsigned char afi, unsigned char datalen, const unsigned char *pData,
												unsigned char *pBuffer);

extern "C" int RFID_API API_ISO15693_Read(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
											unsigned char blk_add, unsigned char num_blk,
                                            unsigned char *uid, unsigned char *buffer);

extern "C" int RFID_API API_ISO15693_Write(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                            unsigned char blk_add, unsigned char num_blk,
                                            unsigned char *uid, unsigned char *data);

extern "C" int RFID_API API_ISO15693_Lock(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                            unsigned char num_blk, unsigned char *uid, unsigned char  *buffer);

extern "C" int RFID_API API_ISO15693_StayQuiet(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
                                                unsigned char *uid,  unsigned char  *buffer );

extern "C" int RFID_API API_ISO15693_Select(SOCKET commHandle, int DeviceAddress, unsigned char flags,
											unsigned char *uid,  unsigned char  *buffer );

extern "C" int RFID_API API_ISO15693_ResetToReady(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
													unsigned char *uid,  unsigned char *buffer );

extern "C" int RFID_API API_ISO15693_WriteAFI(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char afi, unsigned char *uid, unsigned char *buffer);

extern "C" int RFID_API API_ISO15693_LockAFI(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char *uid, unsigned char *buffer );

extern "C" int RFID_API API_ISO15693_WriteDSFID(SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char DSFID, unsigned char *uid, unsigned char *buffer);

extern "C" int RFID_API API_ISO15693_LockDSFID(	SOCKET commHandle, int DeviceAddress, unsigned char flags,
												unsigned char *uid, unsigned char *buffer );

extern "C" int RFID_API API_ISO15693_GetSysInfo(SOCKET commHandle, int deviceAddress,
												unsigned char flag, unsigned char *uid, unsigned char *buffer);

extern "C" int RFID_API API_ISO15693_GetMulSecurity(SOCKET commHandle, int deviceAddress, unsigned char flag,
													unsigned char blkAddr, unsigned char blkNum, const unsigned char *uid,
													unsigned char *pBuffer);

extern "C" int RFID_API API_ISO15693_TransCmd(	SOCKET commHandle, int DeviceAddress, int cmdSize, unsigned char *cmd,
												unsigned char *pbuffer);


// Mifare Application Function
extern "C" int RFID_API API_MF_Read(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char blk_add, 
									unsigned char num_blk, unsigned char *key, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Write(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char blk_add, 
									 unsigned char num_blk, unsigned char *key, unsigned char *senddata, unsigned char *Buffer);

extern "C" int RFID_API API_MF_InitVal(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num, 
									   unsigned char *key, unsigned char *value, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Dec(	SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num,
									unsigned char *key, unsigned char *value, unsigned char *Buffer);

extern "C" int RFID_API API_MF_Inc(	SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char sec_num,
									unsigned char *key, unsigned char *value, unsigned char *Buffer);

extern "C" int RFID_API API_MF_GET_SNR(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmd,
									   unsigned char *Buffer);

//extern "C" int RFID_API API_MF_Value(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char add_blk, int value);


// CPU Card Function
extern "C" int RFID_API API_MF_PowerOn(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmd, unsigned char *Buffer);

extern "C" int RFID_API API_MF_TransferCMD(SOCKET commHandle, int DeviceAddress, unsigned char mode, unsigned char cmdlength,
										   unsigned char *cmd, unsigned char *Buffer);

extern "C" int RFID_API API_MF_RST_Antenna(SOCKET commHandle, int DeviceAddress, unsigned char *Buffer);

